/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency.communication;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.fortiss.consistency.configuration.ConsistencyConfiguration;
import org.fortiss.consistency.exceptions.EmptyResponseException;
import org.fortiss.consistency.exceptions.FailedConsistencyCheckException;
import org.fortiss.consistency.exceptions.FailedDecryptionException;
import org.fortiss.consistency.exceptions.FailedDeserializationException;
import org.fortiss.consistency.exceptions.FailedEncryptionException;
import org.fortiss.consistency.exceptions.FailedSerializationException;
import org.fortiss.consistency.exceptions.ReceivedErrorException;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.ConsistencyModelElementFactory;
import org.fortiss.consistency.model.communication.TriggerFeedback;
import org.fortiss.consistency.model.communication.TriggerRequest;
import org.fortiss.consistency.model.communication.UserInitialInformation;
import org.fortiss.consistency.model.communication.util.CommunicationResourceFactoryImpl;
import org.fortiss.consistency.utils.ConsistencyUtils;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public class AdapterClient {
    private final AdapterConsistencyConfiguration config;
    private final RestTemplate restTemplate;
    private SSLContext sslContext = null;

    public AdapterClient(AdapterConsistencyConfiguration config) {
        config.logInfo("Starting the " + config.getOwnIdentifier() + " consistency adapter client ...");
        this.config = config;
        this.instantiateSSLContext();
        if (this.sslContext == null) {
            config.logError("Unable to create SSL REST template because TSL/SSL context does not exist. Adapter client cannot be started.");
            this.restTemplate = null;
            return;
        }
        CloseableHttpClient client = HttpClients.custom().setSSLContext(this.sslContext).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)client);
        requestFactory.setReadTimeout(config.getReadTimeoutInMs());
        requestFactory.setConnectionRequestTimeout(config.getConnectionTimeoutInMs());
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        config.logInfo("The " + config.getOwnIdentifier() + " consistency adapter client is ready to trigger consistency checks.");
    }

    public TriggerFeedback triggerConsistencyCheck(List<BasicElementInformation> checkElementsInfo, UserInitialInformation userInfo) throws FailedConsistencyCheckException, FailedSerializationException, FailedEncryptionException {
        TriggerFeedback feedback;
        ResponseEntity receivedResponse;
        URI uri;
        byte[] encryptedRequestBody;
        String serializedRequest;
        if (this.restTemplate == null) {
            return null;
        }
        this.config.logInfo("Adapter client received check trigger from tool and will therefore send a consistency check trigger to the central checker ...");
        this.config.logInternal("- User behind this check request: " + String.valueOf(userInfo));
        Object elementsInfoString = "";
        int n = 1;
        for (BasicElementInformation elementInfo : checkElementsInfo) {
            elementsInfoString = (String)elementsInfoString + "- Element " + n++ + ": [" + ConsistencyUtils.getDetailedElementInfoAsString((BasicElementInformation)elementInfo) + "]\n";
        }
        this.config.logInternal("- Check request contains these initial elements (in total: " + checkElementsInfo.size() + "):\n" + (String)elementsInfoString);
        TriggerRequest request = ConsistencyModelElementFactory.createTriggerRequest(checkElementsInfo, (String)this.config.getOwnIdentifier(), (UserInitialInformation)userInfo);
        CommunicationResourceFactoryImpl communicationFactory = new CommunicationResourceFactoryImpl();
        try {
            serializedRequest = ConsistencyUtils.serializeConsistencyElement((EObject)request, (Resource.Factory)communicationFactory);
        }
        catch (IOException e) {
            String exceptionMessage = "Could not trigger consistency check due to failed request serialization!";
            this.config.logError(exceptionMessage);
            throw new FailedSerializationException(exceptionMessage);
        }
        try {
            boolean encryptionWanted = true;
            String senderIdentifier = this.config.getOwnIdentifier();
            String targetIdentifier = this.config.getConsistencyCheckerIdentifier();
            encryptedRequestBody = ConsistencyUtils.prepareFinalMessage((String)serializedRequest, (boolean)encryptionWanted, (String)senderIdentifier, (String)targetIdentifier, (ConsistencyConfiguration)this.config);
        }
        catch (Exception e) {
            String exceptionMessage = "Failed encryption of  " + String.valueOf(request) + ". Exception message: " + e.getMessage();
            this.config.logError(exceptionMessage);
            throw new FailedEncryptionException(exceptionMessage);
        }
        Object exceptionMessage = "No exception message given.";
        try {
            uri = this.createUriFor(this.config.getConsistencyCheckEndpoint());
        }
        catch (URISyntaxException e) {
            exceptionMessage = e.getMessage();
            uri = null;
        }
        if (uri == null) {
            exceptionMessage = "Could not create a valid URI for the consistency check request. Exception message: " + (String)exceptionMessage;
            this.config.logError((String)exceptionMessage);
            throw new FailedConsistencyCheckException((String)exceptionMessage);
        }
        try {
            receivedResponse = this.restTemplate.postForEntity(uri, (Object)encryptedRequestBody, byte[].class);
        }
        catch (Exception e) {
            exceptionMessage = "Could not request a consistency check. Exception message: " + e.getMessage();
            this.config.logError((String)exceptionMessage);
            throw new FailedConsistencyCheckException((String)exceptionMessage);
        }
        try {
            feedback = this.processConsistencyFeedbackResponse((ResponseEntity<byte[]>)receivedResponse);
        }
        catch (Exception e) {
            exceptionMessage = e.getMessage();
            feedback = null;
        }
        if (feedback == null) {
            throw new FailedConsistencyCheckException((String)exceptionMessage);
        }
        this.config.logInfo("Adapter client received consistency feedback and could process it.\n");
        return feedback;
    }

    private TriggerFeedback processConsistencyFeedbackResponse(ResponseEntity<byte[]> receivedResponse) throws FailedConsistencyCheckException, FailedDecryptionException, EmptyResponseException, ReceivedErrorException, FailedDeserializationException {
        EObject deserializedObject;
        Object exceptionMessage;
        String plaintextResponse;
        if (!receivedResponse.getStatusCode().equals((Object)HttpStatus.OK)) {
            String exceptionMessage2 = "Consistency server responded with an unexpected HTTP status. Cannot continue consistency check. Received HTTP status: '" + receivedResponse.getStatusCode().toString() + "'.";
            this.config.logError(exceptionMessage2);
            throw new FailedConsistencyCheckException(exceptionMessage2);
        }
        byte[] receivedResponseBody = (byte[])receivedResponse.getBody();
        byte[] payload = ConsistencyUtils.getPayloadFromMessage((byte[])receivedResponseBody, (ConsistencyConfiguration)this.config);
        if (ConsistencyUtils.isMessageEncrypted((byte[])receivedResponseBody, (ConsistencyConfiguration)this.config)) {
            try {
                String targetIdentifier = this.config.getOwnIdentifier();
                plaintextResponse = this.config.getEncryptionManager().decryptFor(payload, targetIdentifier);
            }
            catch (Exception e) {
                String exceptionMessage3 = "Failed decryption of received data request from '" + this.config.getConsistencyCheckerIdentifier() + "'. Exception message: " + e.getMessage();
                this.config.logError(exceptionMessage3);
                throw new FailedDecryptionException(exceptionMessage3);
            }
        } else {
            plaintextResponse = this.config.decodeBytes(payload);
        }
        if (plaintextResponse == null || plaintextResponse.isBlank()) {
            exceptionMessage = "Got an empty response from the consistency checking instance!";
            this.config.logError((String)exceptionMessage);
            throw new EmptyResponseException((String)exceptionMessage);
        }
        if (plaintextResponse.startsWith(this.config.getErrorMessageIdentifier())) {
            exceptionMessage = "Consistency server provided an error response. The received error message: '" + plaintextResponse.substring(this.config.getErrorMessageIdentifier().length()) + "'.";
            this.config.logError((String)exceptionMessage);
            throw new ReceivedErrorException((String)exceptionMessage);
        }
        try {
            CommunicationResourceFactoryImpl communicationFactory = new CommunicationResourceFactoryImpl();
            deserializedObject = ConsistencyUtils.deserializeConsistencyElement((String)plaintextResponse, (Resource.Factory)communicationFactory);
        }
        catch (IOException e) {
            String exceptionMessage4 = "Could not process consistency feedback due to failed response deserialization!";
            this.config.logError(exceptionMessage4);
            throw new FailedDeserializationException(exceptionMessage4);
        }
        if (!(deserializedObject instanceof TriggerFeedback)) {
            String exceptionMessage5 = "Received answer is not of type TriggerFeedback!";
            this.config.logError(exceptionMessage5);
            throw new FailedConsistencyCheckException(exceptionMessage5);
        }
        TriggerFeedback feedback = (TriggerFeedback)deserializedObject;
        return feedback;
    }

    private URI createUriFor(String uriPath) throws URISyntaxException {
        String protocol = "https";
        String auth = null;
        String host = this.config.getConsistencyServerAddress();
        int port = this.config.getConsistencyServerPort();
        String query = null;
        String fragment = null;
        return new URI(protocol, auth, host, port, uriPath, query, fragment);
    }

    private void instantiateSSLContext() {
        File keyStoreFile = this.config.getKeyStoreFile();
        File trustStoreFile = this.config.getTrustStoreFile();
        char[] keyStorePassword = this.config.getKeyStorePassword().toCharArray();
        char[] trustStorePassword = this.config.getTrustStorePassword().toCharArray();
        String keyStoreType = this.config.getSslKeyStoreType();
        String keyManagerType = this.config.getSslKeyManagerType();
        try {
            KeyManagerFactory keyManagerFactory;
            TrustManagerFactory trustManagerFactory;
            Throwable throwable = null;
            Object var10_10 = null;
            try (FileInputStream trustStoreStream = new FileInputStream(trustStoreFile);){
                KeyStore trustStore = KeyStore.getInstance(keyStoreType);
                trustStore.load(trustStoreStream, trustStorePassword);
                trustManagerFactory = TrustManagerFactory.getInstance(keyManagerType);
                trustManagerFactory.init(trustStore);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            throwable = null;
            var10_10 = null;
            try (FileInputStream keyStoreStream = new FileInputStream(keyStoreFile);){
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                keyStore.load(keyStoreStream, keyStorePassword);
                keyManagerFactory = KeyManagerFactory.getInstance(keyManagerType);
                keyManagerFactory.init(keyStore, keyStorePassword);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            this.sslContext = SSLContext.getInstance(this.config.getSslProtocol());
            this.sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), SecureRandom.getInstanceStrong());
        }
        catch (Exception e) {
            String errorMessage = "Unable to instantiate TSL/SSL context with key and trust stores.";
            this.config.logError(ConsistencyUtils.appendCausingException((String)errorMessage, (Exception)e));
        }
    }
}

