/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency.communication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.fortiss.consistency.configuration.ConsistencyConfiguration;
import org.fortiss.consistency.exceptions.FailedDecryptionException;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.ConsistencyModelElementFactory;
import org.fortiss.consistency.model.communication.ModelDataFeedback;
import org.fortiss.consistency.model.communication.ModelDataRequest;
import org.fortiss.consistency.model.communication.RequestFulfillment;
import org.fortiss.consistency.model.communication.util.CommunicationResourceFactoryImpl;
import org.fortiss.consistency.model.views.ClassFeature;
import org.fortiss.consistency.model.views.ConsistencyView;
import org.fortiss.consistency.model.views.ConsistencyViewtype;
import org.fortiss.consistency.utils.ConsistencyUtils;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

@SpringBootApplication
public class AdapterDataServer {
    private final String SERVER_NAME;
    private ConfigurableApplicationContext runningServerContext = null;

    public AdapterDataServer() {
        this.SERVER_NAME = "consistency adapter data server";
    }

    public boolean start() {
        AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
        if (config == null) {
            return false;
        }
        config.logInfo("Starting the " + this.SERVER_NAME + " ...");
        try {
            String serverAddress = config.getAdapterServerAddress();
            String serverPort = String.valueOf(config.getAdapterServerPort());
            String serverMaxThreads = String.valueOf(config.getAdapterServerMaxRequestThreads());
            Properties serverProperties = ConsistencyUtils.setRestConsistencyServerProperties((String)this.SERVER_NAME, (String)serverAddress, (String)serverPort, (String)serverMaxThreads, (ConsistencyConfiguration)config);
            this.runningServerContext = ConsistencyUtils.buildAndStartRestConsistencyServer(this.getClass(), (Properties)serverProperties);
            config.logInfo("The " + this.SERVER_NAME + " is ready and waiting for requests on https://" + serverAddress + ":" + serverPort + " with a capacity of " + serverMaxThreads + " threads.");
            return true;
        }
        catch (Exception e) {
            config.logError(ConsistencyUtils.appendCausingException((String)("The " + this.SERVER_NAME + " could not be started."), (Exception)e));
            return false;
        }
    }

    public void stop() {
        AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
        if (config != null) {
            config.logInfo("Stopping the " + this.SERVER_NAME + " ...");
        }
        if (this.runningServerContext != null) {
            this.runningServerContext.close();
        }
        if (config != null) {
            config.logInfo("The " + this.SERVER_NAME + " was stopped.");
        }
    }

    @RestController
    public class AdapterDataServerController {
        @PostMapping(value={"/{requestName}"})
        public ResponseEntity<byte[]> requestAction(@PathVariable String requestName, RequestEntity<byte[]> input) {
            AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
            String fullEndpoint = "/" + requestName;
            if (fullEndpoint.equals(config.getDataRequestEndpoint())) {
                return this.requestData(input);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_IMPLEMENTED).body((Object)config.encodeAsBytes("The endpoint '" + fullEndpoint + "' is not implemented/available."));
        }

        public ResponseEntity<byte[]> requestData(RequestEntity<byte[]> input) {
            String serializedView;
            EObject deserializedObject;
            String decryptedRequest;
            AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
            byte[] inputBody = (byte[])input.getBody();
            CommunicationResourceFactoryImpl communicationFactory = new CommunicationResourceFactoryImpl();
            String ownIdentifier = config.getOwnIdentifier();
            String messageSenderIdentifier = config.getConsistencyCheckerIdentifier();
            byte[] payload = ConsistencyUtils.getPayloadFromMessage((byte[])inputBody, (ConsistencyConfiguration)config);
            if (ConsistencyUtils.isMessageEncrypted((byte[])inputBody, (ConsistencyConfiguration)config)) {
                try {
                    String targetIdentifier = config.getOwnIdentifier();
                    decryptedRequest = config.getEncryptionManager().decryptFor(payload, targetIdentifier);
                }
                catch (FailedDecryptionException e) {
                    String errorMessage = "Received data request could not be decrypted.";
                    return ConsistencyUtils.createEncryptedErrorMessage((String)errorMessage, (String)ownIdentifier, (String)messageSenderIdentifier, (ConsistencyConfiguration)config);
                }
            } else {
                decryptedRequest = config.decodeBytes(payload);
            }
            try {
                deserializedObject = ConsistencyUtils.deserializeConsistencyElement((String)decryptedRequest, (Resource.Factory)communicationFactory);
            }
            catch (IOException e) {
                String errorMessage = "Received data request could not be deserialized.";
                return ConsistencyUtils.createEncryptedErrorMessage((String)errorMessage, (String)ownIdentifier, (String)messageSenderIdentifier, (ConsistencyConfiguration)config);
            }
            if (!(deserializedObject instanceof ModelDataRequest)) {
                String errorMessage = "Received data request is not of correct type (" + String.valueOf(ModelDataRequest.class) + ").";
                return ConsistencyUtils.createEncryptedErrorMessage((String)errorMessage, (String)ownIdentifier, (String)messageSenderIdentifier, (ConsistencyConfiguration)config);
            }
            ModelDataRequest request = (ModelDataRequest)deserializedObject;
            config.logInfo("Data server got a new data request [ID: " + request.getRequestIdentifier() + "] from consistency checker. Processing ...");
            config.logInternal("- User behind data request [ID: " + request.getRequestIdentifier() + "]: " + String.valueOf(request.getUser()));
            Object elementsInfoString = "";
            int n = 1;
            for (BasicElementInformation elementInfo : request.getNeededElementsInfo()) {
                elementsInfoString = (String)elementsInfoString + "- Element " + n++ + ": [" + ConsistencyUtils.getDetailedElementInfoAsString((BasicElementInformation)elementInfo) + "]\n";
            }
            config.logInternal("- Data request [ID: " + request.getRequestIdentifier() + "] is about these elements (in total: " + request.getNeededElementsInfo().size() + "):\n" + (String)elementsInfoString);
            config.logInternal("- Data request [ID: " + request.getRequestIdentifier() + "] contains this viewtype extract: " + String.valueOf(request.getViewtype().getContainedClasses()));
            ModelDataFeedback feedback = this.createDataFeedback(request);
            try {
                serializedView = ConsistencyUtils.serializeConsistencyElement((EObject)feedback, (Resource.Factory)communicationFactory);
            }
            catch (IOException e) {
                String errorMessage = "Data feedback could not be serialized.";
                return ConsistencyUtils.createEncryptedErrorMessage((String)errorMessage, (String)ownIdentifier, (String)messageSenderIdentifier, (ConsistencyConfiguration)config);
            }
            config.logInfo("Data server will send now an answer for the data request [ID: " + request.getRequestIdentifier() + "] to the consistency checker. Processing ...");
            return ConsistencyUtils.createEncryptedResponseMessage((String)serializedView, (String)ownIdentifier, (String)messageSenderIdentifier, (ConsistencyConfiguration)config);
        }

        private ModelDataFeedback createDataFeedback(ModelDataRequest request) {
            IConsistencyProviderService provider = IConsistencyProviderService.getInstance();
            AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
            ConsistencyViewtype viewtype = request.getViewtype();
            EMap classMap = viewtype.getContainedClasses();
            EList neededElementsInfo = request.getNeededElementsInfo();
            ArrayList<EObject> requestedElementsWithFilteredData = new ArrayList<EObject>();
            RequestFulfillment currentFulfillment = RequestFulfillment.FULLY_PROVIDED;
            for (BasicElementInformation neededElementInfo : neededElementsInfo) {
                String neededElementTool = neededElementInfo.getSourceTool();
                if (!neededElementTool.equals(config.getOwnIdentifier())) {
                    currentFulfillment = RequestFulfillment.PARTIALLY_PROVIDED;
                    continue;
                }
                EObject matchedElement = provider.getMatchingElement(neededElementInfo);
                if (matchedElement != null) {
                    EObject transformedElement = provider.transformIntoConsistencyViewtypeElement(matchedElement, (EMap<String, EList<ClassFeature>>)classMap);
                    if (transformedElement != null) {
                        requestedElementsWithFilteredData.add(transformedElement);
                        continue;
                    }
                    config.logError("The following element could not be correctly transformed. Therefore, it is not added to the response data view. Skipped element: " + String.valueOf(matchedElement));
                    continue;
                }
                currentFulfillment = RequestFulfillment.PARTIALLY_PROVIDED;
            }
            if (requestedElementsWithFilteredData.isEmpty()) {
                currentFulfillment = RequestFulfillment.REJECTED;
            }
            ConsistencyView dataView = ConsistencyModelElementFactory.createConsistencyView(requestedElementsWithFilteredData, (String)("View from " + config.getOwnIdentifier() + " for request " + request.getRequestIdentifier()));
            return ConsistencyModelElementFactory.createModelDataFeedback((RequestFulfillment)currentFulfillment, (ConsistencyView)dataView);
        }
    }
}

