/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency.configuration;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.fortiss.consistency.configuration.ConsistencyConfiguration;
import org.fortiss.consistency.security.encryption.IEncryptionManager;
import org.fortiss.tooling.ext.consistency.security.TinkEncryptionManagerForAdapter;

public class AdapterConsistencyConfiguration
extends ConsistencyConfiguration {
    private Logger consistencyLogger = null;
    private String logFilePath = null;
    private Level currentLoggerLevel = null;

    public AdapterConsistencyConfiguration(String resourceFolderPath) {
        super(resourceFolderPath);
    }

    public IEncryptionManager specifyEncryptionManager() {
        return new TinkEncryptionManagerForAdapter(this);
    }

    public String getOwnIdentifier() {
        String defaultIdentifier = "AF3";
        if (this.loader == null) {
            return defaultIdentifier;
        }
        String loadedIdentifier = this.loader.getProperty("adapterIdentifier");
        if (loadedIdentifier == null || loadedIdentifier.isBlank()) {
            return defaultIdentifier;
        }
        return loadedIdentifier;
    }

    public String getOwnPrefix() {
        return "[" + this.getOwnIdentifier() + " C-Adapter]";
    }

    protected List<String> getAllMandatoryPropertyNames() {
        List mandatoryPropertyNames = super.getAllMandatoryPropertyNames();
        mandatoryPropertyNames.addAll(Arrays.asList("adapterIdentifier"));
        mandatoryPropertyNames.addAll(Arrays.asList("adapterServer.address", "adapterServer.port", "adapterServer.maxThreads"));
        mandatoryPropertyNames.addAll(Arrays.asList("loggerLevel", "loggingFolder", "loggerTimestampFormat", "loggerFilePrefix"));
        return mandatoryPropertyNames;
    }

    public void registerAllElements() {
        this.setConsistencyLoggerLevel();
        super.registerAvailableMetaModels();
    }

    public String getPathOfPublicConsistencyEncryptionKeyFile() {
        return this.loader.getProperty("checkerEncryptionPublicKeyFile.internalPath");
    }

    public String getAdapterServerAddress() {
        return this.loader.getProperty("adapterServer.address");
    }

    public int getAdapterServerPort() {
        return Integer.valueOf(this.loader.getProperty("adapterServer.port"));
    }

    public int getAdapterServerMaxRequestThreads() {
        return Integer.valueOf(this.loader.getProperty("adapterServer.maxThreads"));
    }

    private Level getConsistencyLoggerLevel() {
        return this.currentLoggerLevel;
    }

    private void setConsistencyLoggerLevel() {
        switch (this.loader.getProperty("loggerLevel")) {
            case "OFF": {
                this.currentLoggerLevel = Level.OFF;
                break;
            }
            case "SEVERE": {
                this.currentLoggerLevel = Level.SEVERE;
                break;
            }
            case "WARNING": {
                this.currentLoggerLevel = Level.WARNING;
                break;
            }
            case "INFO": {
                this.currentLoggerLevel = Level.INFO;
                break;
            }
            case "CONFIG": {
                this.currentLoggerLevel = Level.CONFIG;
                break;
            }
            case "FINE": {
                this.currentLoggerLevel = Level.FINE;
                break;
            }
            case "FINER": {
                this.currentLoggerLevel = Level.FINER;
                break;
            }
            case "FINEST": {
                this.currentLoggerLevel = Level.FINEST;
                break;
            }
            case "ALL": {
                this.currentLoggerLevel = Level.ALL;
                break;
            }
            default: {
                String warningMessage = "The extracted loggerLevel ('" + this.loader.getProperty("loggerLevel") + "') from the properties/settings files could not be matched to an existing logger level, which is why the default ALL level is now used.";
                this.logWarning(warningMessage);
                this.currentLoggerLevel = Level.ALL;
            }
        }
    }

    public String setupConsistencyLogger() throws Exception {
        Logger logger = Logger.getLogger("ConsistencyAdapterLogger");
        this.setConsistencyLoggerLevel();
        logger.setLevel(this.getConsistencyLoggerLevel());
        if (this.logFilePath == null || this.logFilePath.isBlank()) {
            String dirPath = super.getAbsolutePathOfInternalResourceFile(this.loader.getProperty("loggingFolder"));
            if (dirPath.isBlank()) {
                this.logError("Logger could not be set up correctly. Logging directory path is blank.");
                return null;
            }
            File directory = new File(dirPath);
            if (!directory.exists() || !directory.isDirectory()) {
                directory.mkdirs();
            }
            String timeStamp = new SimpleDateFormat(this.loader.getProperty("loggerTimestampFormat")).format(new Date());
            this.logFilePath = directory.getCanonicalPath() + "/" + this.loader.getProperty("loggerFilePrefix") + "_" + timeStamp + ".log";
        }
        boolean appendMode = true;
        FileHandler loggingFileHandler = new FileHandler(this.logFilePath, appendMode);
        SimpleFormatter formatter = new SimpleFormatter();
        loggingFileHandler.setFormatter(formatter);
        loggingFileHandler.setLevel(this.getConsistencyLoggerLevel());
        logger.addHandler(loggingFileHandler);
        logger.setUseParentHandlers(false);
        this.consistencyLogger = logger;
        return this.logFilePath;
    }

    public void logError(String message) {
        super.logError(message);
        if (this.consistencyLogger != null) {
            this.consistencyLogger.setLevel(this.getConsistencyLoggerLevel());
            this.consistencyLogger.severe(message);
        }
    }

    public void logWarning(String message) {
        super.logWarning(message);
        if (this.consistencyLogger != null) {
            this.consistencyLogger.setLevel(this.getConsistencyLoggerLevel());
            this.consistencyLogger.warning(message);
        }
    }

    public void logInfo(String message) {
        super.logInfo(message);
        if (this.consistencyLogger != null) {
            this.consistencyLogger.setLevel(this.getConsistencyLoggerLevel());
            this.consistencyLogger.info(message);
        }
    }

    public void logInternal(String message) {
        super.logInternal(message);
        if (this.consistencyLogger != null) {
            this.consistencyLogger.setLevel(this.getConsistencyLoggerLevel());
            this.consistencyLogger.fine(message);
        }
    }

    public void logPerformance(String message) {
        super.logPerformance(message);
        if (this.consistencyLogger != null) {
            this.consistencyLogger.setLevel(this.getConsistencyLoggerLevel());
            this.consistencyLogger.finer(message);
        }
    }

    public void logDebug(String message) {
        super.logDebug(message);
        if (this.consistencyLogger != null) {
            this.consistencyLogger.setLevel(this.getConsistencyLoggerLevel());
            this.consistencyLogger.finest(message);
        }
    }
}

