/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency.security;

import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.config.TinkConfig;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.fortiss.consistency.configuration.ConsistencyConfiguration;
import org.fortiss.consistency.security.encryption.TinkEncryptionManager;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;

public class TinkEncryptionManagerForAdapter
extends TinkEncryptionManager {
    private final AdapterConsistencyConfiguration extendedConfig;

    public TinkEncryptionManagerForAdapter(AdapterConsistencyConfiguration config) {
        super((ConsistencyConfiguration)config);
        this.extendedConfig = config;
    }

    public boolean performInitialSetup() {
        try {
            TinkConfig.register();
            KeysetHandle ownPrivateKey = this.getKeysetHandleFromResFile(this.extendedConfig.getPathOfPrivateEncryptionKeyFile());
            KeysetHandle ownPublicKey = this.getKeysetHandleFromResFile(this.extendedConfig.getPathOfPublicEncryptionKeyFile());
            this.privateKeysPerAgent.put(this.extendedConfig.getOwnIdentifier(), ownPrivateKey);
            this.publicKeysPerAgent.put(this.extendedConfig.getOwnIdentifier(), ownPublicKey);
            KeysetHandle ccccPublicKey = this.getKeysetHandleFromResFile(this.extendedConfig.getPathOfPublicConsistencyEncryptionKeyFile());
            this.publicKeysPerAgent.put(this.extendedConfig.getConsistencyCheckerIdentifier(), ccccPublicKey);
            return true;
        }
        catch (IOException | GeneralSecurityException e) {
            return false;
        }
    }
}

