/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.views.ClassFeature;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProvider;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.service.base.IObjectAware;

public class ConsistencyProviderService
extends EObjectAwareServiceBase<IConsistencyProvider<EObject>>
implements IConsistencyProviderService {
    private static ConsistencyProviderService SINGLETON_INSTANCE;
    private Map<String, List<Class<? extends EObject>>> consistencyToToolClasses = new HashMap<String, List<Class<? extends EObject>>>();
    private Map<Class<? extends EObject>, String> toolToConsistencyClasses = new HashMap<Class<? extends EObject>, String>();

    private ConsistencyProviderService() {
    }

    static synchronized ConsistencyProviderService getInstance() {
        if (SINGLETON_INSTANCE == null) {
            SINGLETON_INSTANCE = new ConsistencyProviderService();
        }
        return SINGLETON_INSTANCE;
    }

    @Override
    public <T extends EObject> void registerConsistencyProvider(IConsistencyProvider<T> provider, Class<T> cls) {
        this.addHandler(cls, (IObjectAware)provider);
        String correspondingClassName = provider.getClassOfCorrespondingConsistencyViewtypeElement().getCanonicalName();
        if (this.consistencyToToolClasses.containsKey(correspondingClassName)) {
            List<Class<? extends EObject>> toolClasses = this.consistencyToToolClasses.get(correspondingClassName);
            toolClasses.add(cls);
        } else {
            ArrayList<Class<T>> newToolClassesList = new ArrayList<Class<T>>();
            newToolClassesList.add(cls);
            this.consistencyToToolClasses.put(correspondingClassName, newToolClassesList);
        }
        if (!this.toolToConsistencyClasses.containsKey(cls)) {
            this.toolToConsistencyClasses.put(cls, correspondingClassName);
        }
    }

    public String getIntrospectionLabel() {
        return "Consistency Provider Service";
    }

    public String getIntrospectionDescription() {
        return "Service providing consistency methods for given model elements.";
    }

    protected String getExtensionPointName() {
        return "org.fortiss.tooling.ext.consistency.consistencyProvider";
    }

    protected String getConfigurationElementName() {
        return "consistencyProvider";
    }

    protected String getHandlerClassAttribute() {
        return "provider";
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    @Override
    public EObject getMatchingElement(BasicElementInformation neededElementInfo) {
        List<Class<? extends EObject>> possibleClasses = this.getPossibleToolClassesForConsistencyClassName(neededElementInfo.getElementClassString());
        if (possibleClasses != null && !possibleClasses.isEmpty()) {
            for (Class<? extends EObject> possibleClass : possibleClasses) {
                IConsistencyProvider<EObject> provider = this.getConsistencyProvider(possibleClass);
                if (provider == null) continue;
                return provider.getMatchingElement(neededElementInfo);
            }
        }
        return null;
    }

    @Override
    public EObject transformIntoConsistencyViewtypeElement(EObject sourceElement, EMap<String, EList<ClassFeature>> featuresPerClass) {
        IConsistencyProvider<EObject> provider = this.getConsistencyProvider(sourceElement);
        if (provider != null) {
            return provider.transformIntoConsistencyViewtypeElement(sourceElement, featuresPerClass);
        }
        return null;
    }

    @Override
    public Class<?> getClassOfCorrespondingConsistencyViewtypeElement(EObject element) {
        IConsistencyProvider<EObject> provider = this.getConsistencyProvider(element);
        if (provider != null) {
            return provider.getClassOfCorrespondingConsistencyViewtypeElement();
        }
        return null;
    }

    @Override
    public List<Class<? extends EObject>> getPossibleToolClassesForConsistencyClassName(String consistencyClassName) {
        if (this.consistencyToToolClasses.containsKey(consistencyClassName)) {
            return this.consistencyToToolClasses.get(consistencyClassName);
        }
        return null;
    }

    @Override
    public String getConsistencyClassNameForToolClass(Class<? extends EObject> toolElementClass) {
        for (Map.Entry<Class<? extends EObject>, String> entry : this.toolToConsistencyClasses.entrySet()) {
            Class<? extends EObject> registeredToolClass = entry.getKey();
            if (!registeredToolClass.isAssignableFrom(toolElementClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    private IConsistencyProvider<EObject> getConsistencyProvider(EObject element) {
        return this.getConsistencyProvider(element.getClass());
    }

    private IConsistencyProvider<EObject> getConsistencyProvider(Class<?> elementClass) {
        List registeredHandlers = this.getRegisteredHandlers(elementClass);
        if (registeredHandlers != null && registeredHandlers.size() >= 1) {
            return (IConsistencyProvider)registeredHandlers.get(0);
        }
        return null;
    }
}

