/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.consistency.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.consistency.model.BasicElementInformation;
import org.fortiss.consistency.model.views.ClassFeature;
import org.fortiss.consistency.viewtypes.architectureElements.Architecture;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElement;
import org.fortiss.consistency.viewtypes.architectureElements.ArchitectureElementsPackage;
import org.fortiss.consistency.viewtypes.basics.BasicsPackage;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.ext.consistency.ConsistencyAdapterEnvironment;
import org.fortiss.tooling.ext.consistency.configuration.AdapterConsistencyConfiguration;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProvider;
import org.fortiss.tooling.ext.consistency.service.IConsistencyProviderService;
import org.fortiss.tooling.kernel.model.FortissToolingKernelPackage;
import org.fortiss.tooling.kernel.model.IIdLabeled;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public abstract class FortissToolingKernelConsistencyProviderBase<T extends EObject>
implements IConsistencyProvider<T> {
    protected abstract EObject getModel(String var1);

    @Override
    public EObject getMatchingElement(BasicElementInformation neededElementInfo) {
        String neededElementModel = neededElementInfo.getSourceModel();
        String neededElementClassString = neededElementInfo.getElementClassString();
        String neededElementId = neededElementInfo.getElementId();
        String neededElementName = neededElementInfo.getElementName();
        EObject foundModel = this.getModel(neededElementModel);
        if (foundModel == null) {
            return null;
        }
        List<Class<? extends EObject>> neededElementClasses = IConsistencyProviderService.getInstance().getPossibleToolClassesForConsistencyClassName(neededElementClassString);
        if (neededElementClasses == null) {
            return null;
        }
        IIdLabeled matchedElement = null;
        IIdLabeled idMatch = KernelModelElementUtils.findElementById((int)Integer.valueOf(neededElementId), (EObject)foundModel);
        AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
        if (idMatch != null) {
            matchedElement = idMatch;
            if (idMatch instanceof INamedElement && !((INamedElement)idMatch).getName().equals(neededElementName)) {
                config.logWarning("An element with ID '" + neededElementId + "' and name '" + neededElementName + "' was searched, but the found element with the same ID does not have the same name (anymore). It is now assumed that the element was still correctly matched and the name was only updated in the meantime. If this is not the case, please check this. The EObject assumed as correct match: " + String.valueOf(matchedElement));
            }
        } else {
            INamedElement nameMatch = null;
            for (Class<? extends EObject> neededElementClass : neededElementClasses) {
                if (neededElementClass.isAssignableFrom(INamedElement.class) && (nameMatch = KernelModelElementUtils.findContentElementByNameAndClass((EObject)foundModel, (String)neededElementName, INamedElement.class)) != null) break;
            }
            if (nameMatch != null) {
                matchedElement = nameMatch;
                config.logWarning("An element with ID '" + neededElementId + "' and name '" + neededElementName + "' was searched, but no element with this ID exists (anymore). Since an element with the same name was found, it is now assumed that this element was meant. If this is not the case, please check this. The EObject assumed as correct match: " + String.valueOf(matchedElement));
            } else {
                config.logWarning("An element with ID '" + neededElementId + "' and name '" + neededElementName + "' was searched, but no element with this ID exists (anymore) and also no element has the same name. Therefore, no match is returned. ");
            }
        }
        return matchedElement;
    }

    protected List<String> getFeatureNamesForCurrentClass(EMap<String, EList<ClassFeature>> featuresPerClass) {
        Class<?> elementClass = this.getClassOfCorrespondingConsistencyViewtypeElement();
        return FortissToolingKernelConsistencyProviderBase.getFeatureNamesForClass(featuresPerClass, elementClass);
    }

    public static List<String> getFeatureNamesForClass(EMap<String, EList<ClassFeature>> featuresPerClass, Class<?> clazz) {
        EPackage foundMetamodel;
        EClassifier eClassifier;
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList allRelatedClasses = new ArrayList();
        AdapterConsistencyConfiguration config = ConsistencyAdapterEnvironment.getInstance().getConfiguration();
        List metamodels = config.getAllAvailableMetamodels();
        String classNsPrefix = clazz.getPackageName();
        String simpleClassName = clazz.getSimpleName();
        Optional<EPackage> possibleMetamodel = metamodels.stream().filter(metamodel -> metamodel.getNsPrefix().equals(classNsPrefix)).findFirst();
        if (possibleMetamodel.isPresent() && (eClassifier = (foundMetamodel = possibleMetamodel.get()).getEClassifier(simpleClassName)) != null) {
            EClass metaClass = (EClass)eClassifier;
            EList superTypes = metaClass.getEAllSuperTypes();
            for (EClass superType : superTypes) {
                allRelatedClasses.add(superType.getInstanceClass());
            }
        }
        allRelatedClasses.add(clazz);
        BasicEList neededFeatures = new BasicEList();
        for (Class clazz2 : allRelatedClasses) {
            String className = clazz2.getCanonicalName();
            if (!featuresPerClass.containsKey((Object)className)) continue;
            neededFeatures.addAll((Collection)featuresPerClass.get((Object)className));
        }
        List<String> list = neededFeatures.stream().map(feature -> feature.getFeatureName()).collect(Collectors.toList());
        return list;
    }

    protected void transformBasicInformation(EObject sourceElementInTool, EObject targetElementInConsistency, List<String> neededFeatureNames) {
        ArrayList<Pair> basicFeaturePairs = new ArrayList<Pair>();
        basicFeaturePairs.add(new Pair((Object)BasicsPackage.Literals.IID_ELEMENT__ID, (Object)FortissToolingKernelPackage.Literals.IID_LABELED__ID));
        basicFeaturePairs.add(new Pair((Object)BasicsPackage.Literals.INAMED_ELEMENT__NAME, (Object)FortissToolingKernelPackage.Literals.INAMED_ELEMENT__NAME));
        basicFeaturePairs.add(new Pair((Object)BasicsPackage.Literals.INAMED_COMMENTED_ELEMENT__COMMENT, (Object)FortissToolingKernelPackage.Literals.INAMED_COMMENTED_ELEMENT__COMMENT));
        for (Pair basicFeaturePair : basicFeaturePairs) {
            Object toolingKernelFeatureValue;
            EStructuralFeature consistencyViewtypeFeature = (EStructuralFeature)basicFeaturePair.getKey();
            EStructuralFeature toolingKernelFeature = (EStructuralFeature)basicFeaturePair.getValue();
            if (!neededFeatureNames.contains(consistencyViewtypeFeature.getName()) || (toolingKernelFeatureValue = sourceElementInTool.eGet(toolingKernelFeature)) == null) continue;
            if (consistencyViewtypeFeature.equals(BasicsPackage.Literals.IID_ELEMENT__ID)) {
                toolingKernelFeatureValue = String.valueOf(toolingKernelFeatureValue);
            }
            targetElementInConsistency.eSet(consistencyViewtypeFeature, toolingKernelFeatureValue);
        }
    }

    protected void transformContainedElements(IHierarchicElementContainer sourceElement, Architecture targetElement, EMap<String, EList<ClassFeature>> featuresPerClass) {
        EReference currentFeature;
        IConsistencyProviderService consistencyService = IConsistencyProviderService.getInstance();
        Class<?> elementClass = consistencyService.getClassOfCorrespondingConsistencyViewtypeElement((EObject)sourceElement);
        List<String> neededFeatureNames = FortissToolingKernelConsistencyProviderBase.getFeatureNamesForClass(featuresPerClass, elementClass);
        if (neededFeatureNames.contains((currentFeature = ArchitectureElementsPackage.Literals.ARCHITECTURE__CONTAINED_ELEMENTS).getName())) {
            EList containedElements = sourceElement.getContainedElements();
            for (IHierarchicElement containedElement : containedElements) {
                EObject transformedContainedElement = consistencyService.transformIntoConsistencyViewtypeElement((EObject)containedElement, featuresPerClass);
                if (!(transformedContainedElement instanceof ArchitectureElement)) continue;
                targetElement.getContainedElements().add((Object)((ArchitectureElement)transformedContainedElement));
            }
        }
    }

    protected void transformContainedElements(IHierarchicElementContainer sourceElement, ArchitectureElement targetElement, EMap<String, EList<ClassFeature>> featuresPerClass) {
        EReference currentFeature;
        IConsistencyProviderService consistencyService = IConsistencyProviderService.getInstance();
        Class<?> elementClass = consistencyService.getClassOfCorrespondingConsistencyViewtypeElement((EObject)sourceElement);
        List<String> neededFeatureNames = FortissToolingKernelConsistencyProviderBase.getFeatureNamesForClass(featuresPerClass, elementClass);
        if (neededFeatureNames.contains((currentFeature = ArchitectureElementsPackage.Literals.ARCHITECTURE_ELEMENT__CONTAINED_ELEMENTS).getName())) {
            EList containedElements = sourceElement.getContainedElements();
            for (IHierarchicElement containedElement : containedElements) {
                EObject transformedContainedElement = IConsistencyProviderService.getInstance().transformIntoConsistencyViewtypeElement((EObject)containedElement, featuresPerClass);
                if (!(transformedContainedElement instanceof ArchitectureElement)) continue;
                targetElement.getContainedElements().add((Object)((ArchitectureElement)transformedContainedElement));
            }
        }
    }
}

