/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.manufacturing.topology.ui.editor.structure.visual;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.fortiss.af3.manufacturing.topology.model.Station;
import org.fortiss.af3.manufacturing.topology.model.annotation.Capability;
import org.fortiss.af3.manufacturing.topology.model.annotation.Position;
import org.fortiss.af3.manufacturing.topology.ui.AF3ManufacturingTopologyUIActivator;
import org.fortiss.af3.manufacturing.topology.ui.DefaultStyle;
import org.fortiss.tooling.base.model.layout.ILayoutData;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.impl.PointImpl;
import org.fortiss.tooling.base.ui.editor.fx.visual.NamedLayoutedRectangularAnchorageItemVisual;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.util.GraphicUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class StationVisual
extends NamedLayoutedRectangularAnchorageItemVisual<Station> {
    private static final Image ICON = GraphicUtils.getFXImage((String)AF3ManufacturingTopologyUIActivator.PLUGIN_ID, (String)"/icons/station.png");
    private static final Color COLOR = GraphicUtils.convertColor((org.eclipse.swt.graphics.Color)DefaultStyle.STATION_BACKGROUND);

    public StationVisual(IContentMVCBundle mvcb) {
        super(mvcb, Station.class, Position.class, Capability.class);
        EObject model = (EObject)mvcb.getModel();
        model.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                String annotationPositionString;
                int layoutDataY;
                Station station;
                ILayoutData layoutData;
                int layoutDataX;
                String layoutPositionString;
                super.notifyChanged(notification);
                if (notification.getNotifier() instanceof Position && !(layoutPositionString = "[" + (layoutDataX = ((PointImpl)(layoutData = (ILayoutData)(station = (Station)((EObject)notification.getNotifier()).eContainer()).getLayoutData().get(0))).getX()) + ", " + (layoutDataY = ((PointImpl)layoutData).getY()) + "]").equals(annotationPositionString = notification.getNewStringValue())) {
                    try {
                        String[] annotationPositionSubstrings = annotationPositionString.replaceAll("[\\[\\]]", "").split(", ");
                        if (annotationPositionSubstrings.length >= 2) {
                            layoutDataX = Integer.parseInt(annotationPositionSubstrings[0]);
                            layoutDataY = Integer.parseInt(annotationPositionSubstrings[1]);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new NumberFormatException("Input position is not valid.");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Positioning failed. Please try again.");
                    }
                    StationVisual.this.updatePosition((ILayoutedModelElement)station, layoutDataX, layoutDataY);
                }
            }
        });
    }

    private void updatePosition(ILayoutedModelElement item, int x, int y) {
        KernelModelElementUtils.runAsCommand((EObject)item, () -> LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)item, (int)x, (int)y));
    }

    protected Image getIcon() {
        return ICON;
    }

    protected Paint getFillColor() {
        return COLOR;
    }
}

