/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safety.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SafetyStandard implements Enumerator
{
    UNDEFINED(0, "undefined", "undefined"),
    IEC61508(1, "IEC61508", "IEC 61508"),
    ISO26262(2, "ISO26262", "ISO 26262"),
    DO178C(3, "DO178C", "DO 178C");

    public static final int UNDEFINED_VALUE = 0;
    public static final int IEC61508_VALUE = 1;
    public static final int ISO26262_VALUE = 2;
    public static final int DO178C_VALUE = 3;
    private static final SafetyStandard[] VALUES_ARRAY;
    public static final List<SafetyStandard> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SafetyStandard[]{UNDEFINED, IEC61508, ISO26262, DO178C};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SafetyStandard get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SafetyStandard result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SafetyStandard getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SafetyStandard result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SafetyStandard get(int value) {
        switch (value) {
            case 0: {
                return UNDEFINED;
            }
            case 1: {
                return IEC61508;
            }
            case 2: {
                return ISO26262;
            }
            case 3: {
                return DO178C;
            }
        }
        return null;
    }

    private SafetyStandard(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

