/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safety.model.annotation.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.platform.hierarchic.model.node.INodeDomain;
import org.fortiss.af3.platform.hierarchic.model.processor.IProcessorDomain;
import org.fortiss.af3.platform.hierarchic.model.tile.ITileDomain;
import org.fortiss.af3.safety.model.ASIL;
import org.fortiss.af3.safety.model.DAL;
import org.fortiss.af3.safety.model.SIL;
import org.fortiss.af3.safety.model.SafetyStandard;
import org.fortiss.af3.safety.model.annotation.SafetyAnnotationPackage;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.af3.safety.model.annotation.impl.SafetyIntegrityLevelImpl;
import org.fortiss.af3.safety.utils.SafetyUtils;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class SafetyIntegrityLevelStaticImpl {
    private static final Map<ASIL, DAL> asilToDalConvMap = Collections.unmodifiableMap(new HashMap<ASIL, DAL>(){
        {
            this.put(ASIL.QM, DAL.DALE);
            this.put(ASIL.ASILA, DAL.DALD);
            this.put(ASIL.ASILB, DAL.DALC);
            this.put(ASIL.ASILC, DAL.DALB);
            this.put(ASIL.ASILD, DAL.DALA);
        }
    });
    private static final Map<ASIL, SIL> asilToSilConvMap = Collections.unmodifiableMap(new HashMap<ASIL, SIL>(){
        {
            this.put(ASIL.QM, SIL.SIL0);
            this.put(ASIL.ASILA, SIL.SIL1);
            this.put(ASIL.ASILB, SIL.SIL2);
            this.put(ASIL.ASILC, SIL.SIL2);
            this.put(ASIL.ASILD, SIL.SIL3);
        }
    });
    private static final Map<DAL, ASIL> dalToAsilConvMap = Collections.unmodifiableMap(new HashMap<DAL, ASIL>(){
        {
            this.put(DAL.DALE, ASIL.QM);
            this.put(DAL.DALD, ASIL.ASILA);
            this.put(DAL.DALC, ASIL.ASILC);
            this.put(DAL.DALB, ASIL.ASILD);
            this.put(DAL.DALA, ASIL.ASILD);
        }
    });
    private static final Map<DAL, SIL> dalToSilConvMap = Collections.unmodifiableMap(new HashMap<DAL, SIL>(){
        {
            this.put(DAL.DALE, SIL.SIL0);
            this.put(DAL.DALD, SIL.SIL1);
            this.put(DAL.DALC, SIL.SIL2);
            this.put(DAL.DALB, SIL.SIL3);
            this.put(DAL.DALA, SIL.SIL4);
        }
    });
    private static final Map<SIL, ASIL> silToAsilConvMap = Collections.unmodifiableMap(new HashMap<SIL, ASIL>(){
        {
            this.put(SIL.SIL0, ASIL.ASILA);
            this.put(SIL.SIL1, ASIL.ASILA);
            this.put(SIL.SIL2, ASIL.ASILC);
            this.put(SIL.SIL3, ASIL.ASILD);
            this.put(SIL.SIL4, ASIL.ASILD);
        }
    });
    private static final Map<SIL, DAL> silToDalConvMap = Collections.unmodifiableMap(new HashMap<SIL, DAL>(){
        {
            this.put(SIL.SIL0, DAL.DALE);
            this.put(SIL.SIL1, DAL.DALD);
            this.put(SIL.SIL2, DAL.DALC);
            this.put(SIL.SIL3, DAL.DALB);
            this.put(SIL.SIL4, DAL.DALA);
        }
    });

    public static Enumerator getDerivedValue(SafetyIntegrityLevel specification) {
        IModelElement parent;
        IModelElement modelElement = specification.getSpecificationOf();
        if (SafetyUtils.isSafetyStandardElement(modelElement)) {
            return null;
        }
        if (modelElement instanceof INodeDomain) {
            if (modelElement instanceof IHierarchicElementContainer) {
                if (SafetyUtils.haveDirectChildsSpecifiedSIL(modelElement)) {
                    Integer lowestChildSIL = SafetyUtils.getLowestChildSafetyLevelValue(specification, false);
                    return (Enumerator)SafetyUtils.getSafetyIntegrityLevelEnumOf(specification)[lowestChildSIL];
                }
                return specification.getUserAnnotatedValue();
            }
        } else if (modelElement instanceof ITileDomain) {
            Enumerator value = specification.getUserAnnotatedValue();
            if (value == null && modelElement instanceof IHierarchicElement) {
                IModelElement parent2 = (IModelElement)((IHierarchicElement)modelElement).getContainer();
                SafetyIntegrityLevel parentAnn = (SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)parent2, SafetyIntegrityLevel.class);
                return parentAnn.getUserAnnotatedValue();
            }
        } else if (modelElement instanceof IProcessorDomain && modelElement instanceof IHierarchicElement) {
            IModelElement parent3 = (IModelElement)((IHierarchicElement)modelElement).getContainer();
            return (Enumerator)AnnotationUtils.getAnnotationValue((IModelElement)parent3, SafetyIntegrityLevel.class, Enumerator.class);
        }
        Enumerator thisValue = specification.getUserAnnotatedValue();
        if (modelElement instanceof IHierarchicElement && (parent = (IModelElement)EcoreUtils.getFirstParentWith((EObject)modelElement, SafetyUtils.isUserSafetyLevelPresent())) != null && !SafetyUtils.isSafetyStandardElement(parent)) {
            return (Enumerator)AnnotationUtils.getAnnotationValue((IModelElement)parent, SafetyIntegrityLevel.class, Enumerator.class);
        }
        return thisValue;
    }

    public static Enumerator getUserAnnotatedValue(SafetyIntegrityLevelImpl specification) {
        SafetyStandard safetyStandard = SafetyUtils.getSafetyStandardOf(specification);
        return safetyStandard != SafetyStandard.UNDEFINED && specification.isIsSafetyValueSet() ? (Enumerator)specification.eGet((EStructuralFeature)SafetyUtils.getSafetyEnumeratorOf(safetyStandard)) : null;
    }

    public static int getSafetyLevelValueOf(SafetyIntegrityLevel specification, SafetyStandard domain) {
        if (specification != null) {
            return ((Enumerator)specification.eGet((EStructuralFeature)SafetyUtils.getSafetyEnumeratorOf(domain))).getValue();
        }
        return -1;
    }

    public static EStructuralFeature getDerivedFeature(SafetyIntegrityLevel specification) {
        IModelElement modelElement = specification.getSpecificationOf();
        IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)modelElement, IProjectRootElement.class, (boolean)false);
        SafetyStandard safetyStandard = SafetyUtils.getSafetyStandardOf(specification);
        if (modelElement == rootElement || SafetyUtils.isElementTopElement(modelElement)) {
            return SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__SAFETY_STANDARD;
        }
        return SafetyUtils.getSafetyEnumeratorOf(safetyStandard);
    }

    public static Enumerator setValue(SafetyIntegrityLevel specification, Enumerator value) {
        if (specification == null) {
            return null;
        }
        IModelElement modelElement = specification.getSpecificationOf();
        if (SafetyUtils.isSafetyStandardElement(modelElement) && value instanceof SafetyStandard) {
            return SafetyIntegrityLevelStaticImpl.setSafetyStandard(specification, (SafetyStandard)value);
        }
        SafetyStandard safetyStandard = SafetyUtils.getSafetyStandardOf(specification);
        if (value == SIL.UNDEFINED || value == ASIL.UNDEFINED || value == DAL.UNDEFINED) {
            specification.eUnset((EStructuralFeature)SafetyUtils.getSafetyEnumeratorOf(safetyStandard));
            specification.setIsSafetyValueSet(false);
            return (Enumerator)specification.eGet(SafetyIntegrityLevelStaticImpl.getDerivedFeature(specification));
        }
        if (safetyStandard != SafetyStandard.UNDEFINED) {
            specification.eSet((EStructuralFeature)SafetyUtils.getSafetyEnumeratorOf(safetyStandard), value);
            specification.setIsSafetyValueSet(true);
            return (Enumerator)specification.eGet(SafetyIntegrityLevelStaticImpl.getDerivedFeature(specification));
        }
        return null;
    }

    public static Enumerator setSafetyStandard(SafetyIntegrityLevel specification, SafetyStandard value) {
        if (specification == null || SafetyUtils.getSafetyStandardOf(specification) == value) {
            return null;
        }
        SafetyStandard previoussafetyStandard = SafetyUtils.getSafetyStandardOf(specification);
        specification.setSafetyStandard(value);
        IModelElement modelElement = specification.getSpecificationOf();
        IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)modelElement, IProjectRootElement.class, (boolean)false);
        if (previoussafetyStandard == SafetyStandard.ISO26262) {
            if (value == SafetyStandard.DO178C) {
                SafetyIntegrityLevelStaticImpl.asilToDalMigrator((List<SafetyIntegrityLevel>)EcoreUtils.getChildrenWithType((EObject)rootElement, SafetyIntegrityLevel.class));
                return value;
            }
            if (value == SafetyStandard.IEC61508) {
                SafetyIntegrityLevelStaticImpl.asilToSilMigrator((List<SafetyIntegrityLevel>)EcoreUtils.getChildrenWithType((EObject)rootElement, SafetyIntegrityLevel.class));
                return value;
            }
        } else if (previoussafetyStandard == SafetyStandard.DO178C) {
            if (value == SafetyStandard.ISO26262) {
                SafetyIntegrityLevelStaticImpl.dalToAsilMigrator((List<SafetyIntegrityLevel>)EcoreUtils.getChildrenWithType((EObject)rootElement, SafetyIntegrityLevel.class));
                return value;
            }
            if (value == SafetyStandard.IEC61508) {
                SafetyIntegrityLevelStaticImpl.dalToSilMigrator((List<SafetyIntegrityLevel>)EcoreUtils.getChildrenWithType((EObject)rootElement, SafetyIntegrityLevel.class));
                return value;
            }
        } else if (previoussafetyStandard == SafetyStandard.IEC61508) {
            if (value == SafetyStandard.ISO26262) {
                SafetyIntegrityLevelStaticImpl.silToAsilMigrator((List<SafetyIntegrityLevel>)EcoreUtils.getChildrenWithType((EObject)rootElement, SafetyIntegrityLevel.class));
                return value;
            }
            if (value == SafetyStandard.DO178C) {
                SafetyIntegrityLevelStaticImpl.silToDalMigrator((List<SafetyIntegrityLevel>)EcoreUtils.getChildrenWithType((EObject)rootElement, SafetyIntegrityLevel.class));
                return value;
            }
        }
        return null;
    }

    public static void asilToDalMigrator(List<SafetyIntegrityLevel> specificationsToAdapt) {
        for (SafetyIntegrityLevel currentSpecification : specificationsToAdapt) {
            ASIL currentAsilValue = currentSpecification.getAsilValue();
            currentSpecification.setDalValue(asilToDalConvMap.get((Object)currentAsilValue));
            EAttribute asilAttr = SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__ASIL_VALUE;
            currentSpecification.eUnset((EStructuralFeature)asilAttr);
        }
    }

    public static void asilToSilMigrator(List<SafetyIntegrityLevel> specificationsToAdapt) {
        for (SafetyIntegrityLevel currentSpecification : specificationsToAdapt) {
            ASIL currentAsilValue = currentSpecification.getAsilValue();
            currentSpecification.setSilValue(asilToSilConvMap.get((Object)currentAsilValue));
            EAttribute asilAttr = SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__ASIL_VALUE;
            currentSpecification.eUnset((EStructuralFeature)asilAttr);
        }
    }

    public static void dalToAsilMigrator(List<SafetyIntegrityLevel> specificationsToAdapt) {
        for (SafetyIntegrityLevel currentSpecification : specificationsToAdapt) {
            DAL currentDalValue = currentSpecification.getDalValue();
            currentSpecification.setAsilValue(dalToAsilConvMap.get((Object)currentDalValue));
            EAttribute dalAttr = SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__DAL_VALUE;
            currentSpecification.eUnset((EStructuralFeature)dalAttr);
        }
    }

    public static void dalToSilMigrator(List<SafetyIntegrityLevel> specificationsToAdapt) {
        for (SafetyIntegrityLevel currentSpecification : specificationsToAdapt) {
            DAL currentDalValue = currentSpecification.getDalValue();
            currentSpecification.setSilValue(dalToSilConvMap.get((Object)currentDalValue));
            EAttribute dalAttr = SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__DAL_VALUE;
            currentSpecification.eUnset((EStructuralFeature)dalAttr);
        }
    }

    public static void silToAsilMigrator(List<SafetyIntegrityLevel> specificationsToAdapt) {
        for (SafetyIntegrityLevel currentSpecification : specificationsToAdapt) {
            SIL currentSilValue = currentSpecification.getSilValue();
            currentSpecification.setAsilValue(silToAsilConvMap.get((Object)currentSilValue));
            EAttribute silAttr = SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__SIL_VALUE;
            currentSpecification.eUnset((EStructuralFeature)silAttr);
        }
    }

    public static void silToDalMigrator(List<SafetyIntegrityLevel> specificationsToAdapt) {
        for (SafetyIntegrityLevel currentSpecification : specificationsToAdapt) {
            SIL currentSilValue = currentSpecification.getSilValue();
            currentSpecification.setDalValue(silToDalConvMap.get((Object)currentSilValue));
            EAttribute silAttr = SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__SIL_VALUE;
            currentSpecification.eUnset((EStructuralFeature)silAttr);
        }
    }
}

