/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safety.model.artefact;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SafetyMechanism implements Enumerator
{
    FAULT_TOLERANT(0, "FAULT_TOLERANT", "FAULT_TOLERANT"),
    FAULT_DETECTION(1, "FAULT_DETECTION", "FAULT_DETECTION");

    public static final int FAULT_TOLERANT_VALUE = 0;
    public static final int FAULT_DETECTION_VALUE = 1;
    private static final SafetyMechanism[] VALUES_ARRAY;
    public static final List<SafetyMechanism> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SafetyMechanism[]{FAULT_TOLERANT, FAULT_DETECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SafetyMechanism get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SafetyMechanism result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SafetyMechanism getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SafetyMechanism result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SafetyMechanism get(int value) {
        switch (value) {
            case 0: {
                return FAULT_TOLERANT;
            }
            case 1: {
                return FAULT_DETECTION;
            }
        }
        return null;
    }

    private SafetyMechanism(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

