/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safety.model.artefact.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.fortiss.af3.safety.model.artefact.Controllability;
import org.fortiss.af3.safety.model.artefact.Exposure;
import org.fortiss.af3.safety.model.artefact.FailureMode;
import org.fortiss.af3.safety.model.artefact.Hazard;
import org.fortiss.af3.safety.model.artefact.LossScenario;
import org.fortiss.af3.safety.model.artefact.SafetyArtefactFactory;
import org.fortiss.af3.safety.model.artefact.SafetyArtefactPackage;
import org.fortiss.af3.safety.model.artefact.SafetyMechanism;
import org.fortiss.af3.safety.model.artefact.Severity;
import org.fortiss.af3.safety.model.artefact.impl.HazardImpl;
import org.fortiss.af3.safety.model.artefact.impl.LossScenarioImpl;

public class SafetyArtefactFactoryImpl
extends EFactoryImpl
implements SafetyArtefactFactory {
    public static SafetyArtefactFactory init() {
        try {
            SafetyArtefactFactory theSafetyArtefactFactory = (SafetyArtefactFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.fortiss.org/af3/safety/artefact");
            if (theSafetyArtefactFactory != null) {
                return theSafetyArtefactFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SafetyArtefactFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createHazard();
            }
            case 1: {
                return this.createLossScenario();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createSafetyMechanismFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createFailureModeFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createSeverityFromString(eDataType, initialValue);
            }
            case 5: {
                return this.createExposureFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createControllabilityFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertSafetyMechanismToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertFailureModeToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertSeverityToString(eDataType, instanceValue);
            }
            case 5: {
                return this.convertExposureToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertControllabilityToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Hazard createHazard() {
        HazardImpl hazard = new HazardImpl();
        return hazard;
    }

    @Override
    public LossScenario createLossScenario() {
        LossScenarioImpl lossScenario = new LossScenarioImpl();
        return lossScenario;
    }

    public SafetyMechanism createSafetyMechanismFromString(EDataType eDataType, String initialValue) {
        SafetyMechanism result = SafetyMechanism.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSafetyMechanismToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public FailureMode createFailureModeFromString(EDataType eDataType, String initialValue) {
        FailureMode result = FailureMode.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFailureModeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Severity createSeverityFromString(EDataType eDataType, String initialValue) {
        Severity result = Severity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Exposure createExposureFromString(EDataType eDataType, String initialValue) {
        Exposure result = Exposure.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertExposureToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Controllability createControllabilityFromString(EDataType eDataType, String initialValue) {
        Controllability result = Controllability.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertControllabilityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public SafetyArtefactPackage getSafetyArtefactPackage() {
        return (SafetyArtefactPackage)this.getEPackage();
    }

    @Deprecated
    public static SafetyArtefactPackage getPackage() {
        return SafetyArtefactPackage.eINSTANCE;
    }
}

