/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.safety.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.af3.component.model.Component;
import org.fortiss.af3.component.model.ComponentArchitecture;
import org.fortiss.af3.component.utils.ComponentUtils;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.safety.model.ASIL;
import org.fortiss.af3.safety.model.DAL;
import org.fortiss.af3.safety.model.SIL;
import org.fortiss.af3.safety.model.SafetyStandard;
import org.fortiss.af3.safety.model.annotation.SafetyAnnotationPackage;
import org.fortiss.af3.safety.model.annotation.SafetyIntegrityLevel;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.AnnotationUtils;
import org.fortiss.tooling.common.util.LambdaUtils;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class SafetyUtils {
    private static final Map<Enumerator, EAttribute> standardToSpecificSIL = Collections.unmodifiableMap(new HashMap<Enumerator, EAttribute>(){
        {
            this.put(SafetyStandard.UNDEFINED, SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__UNDEFINED_STANDARD_VALUE);
            this.put(SafetyStandard.DO178C, SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__DAL_VALUE);
            this.put(SafetyStandard.IEC61508, SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__SIL_VALUE);
            this.put(SafetyStandard.ISO26262, SafetyAnnotationPackage.Literals.SAFETY_INTEGRITY_LEVEL__ASIL_VALUE);
        }
    });

    public static Enum<?>[] getSafetyIntegrityLevelEnumOf(SafetyIntegrityLevel specification) {
        SafetyStandard safetyStandard = SafetyUtils.getSafetyStandardOf(specification);
        if (safetyStandard == SafetyStandard.ISO26262) {
            return ASIL.values();
        }
        if (safetyStandard == SafetyStandard.DO178C) {
            return DAL.values();
        }
        if (safetyStandard == SafetyStandard.IEC61508) {
            return SIL.values();
        }
        return null;
    }

    public static SafetyStandard getSafetyStandardOf(SafetyIntegrityLevel specification) {
        IModelElement currentModelElement;
        IModelElement parentElement = currentModelElement = specification.getSpecificationOf();
        SafetyStandard safetyStandard = specification.getSafetyStandard();
        while (parentElement != null && safetyStandard == SafetyStandard.UNDEFINED) {
            SafetyIntegrityLevel sil;
            if (parentElement instanceof IModelElement && (sil = (SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)(currentModelElement = parentElement), SafetyIntegrityLevel.class)) != null) {
                safetyStandard = sil.getSafetyStandard();
            }
            parentElement = parentElement.eContainer();
        }
        return safetyStandard;
    }

    public static Integer getLowestChildSafetyLevelValue(SafetyIntegrityLevel specification, boolean isReflexive) {
        IModelElement element = specification.getSpecificationOf();
        ArrayList childAnnotations = new ArrayList(EcoreUtils.getChildrenWithType((EObject)element, SafetyIntegrityLevel.class));
        if (!isReflexive) {
            childAnnotations.remove(specification);
        }
        Optional<Integer> lowestSIL = childAnnotations.stream().map(ann -> SafetyUtils.getSafetyLevelValueOf(ann)).reduce(Math::min);
        return lowestSIL.orElse(null);
    }

    public static Integer getLargestParentSafetyLevelValue(SafetyIntegrityLevel specification) {
        return (Integer)SafetyUtils.getLargestParentSafetyLevel(specification).getFirst();
    }

    public static Enumerator getLargestParentSafetyLevelEnum(SafetyIntegrityLevel specification) {
        return (Enumerator)((SafetyIntegrityLevel)SafetyUtils.getLargestParentSafetyLevel(specification).getSecond()).getValue();
    }

    private static Pair<Integer, SafetyIntegrityLevel> getLargestParentSafetyLevel(SafetyIntegrityLevel specification) {
        int largestLevelInHierarchy = 0;
        SafetyIntegrityLevel largestSIL = null;
        EList silAnnotations = AnnotationUtils.getParentAnnotationsWithType((IModelElement)specification.getSpecificationOf(), SafetyIntegrityLevel.class);
        for (SafetyIntegrityLevel currentSIL : silAnnotations) {
            int currentLevel = SafetyUtils.getSafetyLevelValueOf(currentSIL);
            largestSIL = largestLevelInHierarchy < currentLevel ? currentSIL : largestSIL;
            largestLevelInHierarchy = Math.max(largestLevelInHierarchy, currentLevel);
        }
        return new Pair((Object)largestLevelInHierarchy, largestSIL);
    }

    public static boolean isParentLevelSet(SafetyIntegrityLevel specification) {
        IModelElement parent;
        IModelElement element = specification.getSpecificationOf();
        return element instanceof IHierarchicElement && (parent = (IModelElement)EcoreUtils.getFirstParentWith((EObject)element, SafetyUtils.isUserSafetyLevelPresent())) != null;
    }

    public static Predicate<EObject> isUserSafetyLevelPresent() {
        return obj -> {
            SafetyIntegrityLevel sil;
            if (obj instanceof IModelElement && !SafetyUtils.isSafetyStandardElement((IModelElement)obj) && (sil = (SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)((IModelElement)obj), SafetyIntegrityLevel.class)) != null) {
                return sil.getUserAnnotatedValue() != null;
            }
            return false;
        };
    }

    public static boolean isSafetyStandardElement(IModelElement modelElement) {
        boolean isTopComponent;
        boolean bl = isTopComponent = modelElement instanceof Component && ComponentUtils.isTopComponent((Component)((Component)modelElement));
        return modelElement instanceof IProjectRootElement || isTopComponent;
    }

    public static String toString(SafetyIntegrityLevel sil) {
        if (sil.getSafetyStandard().equals((Object)SafetyStandard.IEC61508)) {
            return sil.getAsilValue().toString();
        }
        if (sil.getSafetyStandard().equals((Object)SafetyStandard.ISO26262)) {
            return sil.getSilValue().toString();
        }
        if (sil.getSafetyStandard().equals((Object)SafetyStandard.DO178C)) {
            return sil.getDalValue().toString();
        }
        return "undefined";
    }

    public static int getSafetyLevelValueOf(SafetyIntegrityLevel specification) {
        Enumerator safetyEnum = (Enumerator)AnnotationUtils.getAnnotationValue((IModelElement)specification.getSpecificationOf(), specification.getClass(), Enumerator.class);
        return safetyEnum != null ? safetyEnum.getValue() : 0;
    }

    public static EAttribute getSafetyEnumeratorOf(SafetyStandard domain) {
        return standardToSpecificSIL.get((Object)domain);
    }

    public static boolean haveDirectChildsSpecifiedSIL(IModelElement modelElement) {
        Collection directChildExUs = LambdaUtils.filterByType((Collection)((IHierarchicElementContainer)modelElement).getContainedElements(), ExecutionUnit.class);
        List safetyEnums = directChildExUs.stream().map(e -> ((SafetyIntegrityLevel)AnnotationUtils.getAnnotation((IModelElement)e, SafetyIntegrityLevel.class)).getUserAnnotatedValue()).collect(Collectors.toList());
        Integer maxChildSafetyLevel = safetyEnums.stream().filter(e -> e != null).map(e -> e.getValue()).reduce((e1, e2) -> Math.max(e1, e2)).orElse(0);
        return !safetyEnums.isEmpty() && maxChildSafetyLevel > 0;
    }

    public static Enumerator getStandardSpecificValue(SafetyIntegrityLevel specification) {
        boolean isRootStandardUndefined;
        IModelElement modelElement = specification.getSpecificationOf();
        IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)modelElement, IProjectRootElement.class, (boolean)false);
        SafetyStandard safetyStandard = SafetyUtils.getSafetyStandardOf(specification);
        boolean bl = isRootStandardUndefined = safetyStandard == SafetyStandard.UNDEFINED && modelElement == rootElement;
        if (isRootStandardUndefined || SafetyUtils.isElementTopElement(modelElement)) {
            return safetyStandard;
        }
        return (Enumerator)specification.eGet((EStructuralFeature)SafetyUtils.getSafetyEnumeratorOf(safetyStandard));
    }

    public static boolean isElementTopElement(IModelElement element) {
        if (element instanceof IProjectRootElement) {
            return true;
        }
        IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)element, IProjectRootElement.class, (boolean)false);
        return rootElement instanceof ComponentArchitecture && ((ComponentArchitecture)rootElement).getTopComponent() == element;
    }
}

