/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.ui.editor;

import org.fortiss.af3.platform.hierarchic.model.cluster.Cluster;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.DirectedPlatformConnectorContentVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.DirectedPlatformConnectorDiagramVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.PlatformClusterVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.PlatformExecutionUnitVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.PlatformGatewayUnitVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.PlatformGenericUnitVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.PlatformMemoryUnitVisual;
import org.fortiss.af3.platform.hierarchic.ui.editor.visual.PlatformTransmissionUnitVisual;
import org.fortiss.af3.platform.model.ExecutionUnit;
import org.fortiss.af3.platform.model.GatewayUnit;
import org.fortiss.af3.platform.model.IArchitectureDomain;
import org.fortiss.af3.platform.model.IPlatformArchitectureElement;
import org.fortiss.af3.platform.model.MemoryUnit;
import org.fortiss.af3.platform.model.PlatformConnectorUnit;
import org.fortiss.af3.platform.model.TransmissionConnection;
import org.fortiss.af3.platform.model.TransmissionUnit;
import org.fortiss.af3.platform.ui.editor.structure.visual.TransmissionConnectionVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IContentMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.IDiagramAnchorageMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.mvc.ILinkMVCBundle;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IContentVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IDiagramAnchorageVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.ILinkVisual;
import org.fortiss.tooling.common.ui.javafx.lwfxef.visual.IVisualFactory;

public final class PlatformComponentVisualFactory
implements IVisualFactory {
    public IContentVisual createContentVisual(IContentMVCBundle modelBundle) {
        Object model = modelBundle.getModel();
        if (!(model instanceof IArchitectureDomain)) {
            return null;
        }
        if (model instanceof Cluster) {
            return new PlatformClusterVisual(modelBundle);
        }
        if (model instanceof ExecutionUnit) {
            return new PlatformExecutionUnitVisual(modelBundle);
        }
        if (model instanceof TransmissionUnit) {
            return new PlatformTransmissionUnitVisual(modelBundle);
        }
        if (model instanceof GatewayUnit) {
            return new PlatformGatewayUnitVisual(modelBundle);
        }
        if (model instanceof MemoryUnit) {
            return new PlatformMemoryUnitVisual(modelBundle);
        }
        if (model instanceof IPlatformArchitectureElement) {
            return new PlatformGenericUnitVisual(modelBundle);
        }
        return null;
    }

    public IDiagramAnchorageVisual createDiagramAnchorageVisual(IDiagramAnchorageMVCBundle modelBundle) {
        Object anchorageObj = modelBundle.getModel();
        if (anchorageObj instanceof PlatformConnectorUnit) {
            return new DirectedPlatformConnectorDiagramVisual(modelBundle, anchorageObj.getClass());
        }
        return null;
    }

    public IContentAnchorageVisual createContentAnchorageVisual(IContentAnchorageMVCBundle modelBundle) {
        Object anchorageObj = modelBundle.getModel();
        if (!(anchorageObj instanceof IArchitectureDomain)) {
            return null;
        }
        if (anchorageObj instanceof PlatformConnectorUnit) {
            return new DirectedPlatformConnectorContentVisual(modelBundle, anchorageObj.getClass());
        }
        return null;
    }

    public ILinkVisual createLinkVisual(ILinkMVCBundle modelBundle) {
        Object linkObj = modelBundle.getModel();
        if (linkObj instanceof TransmissionConnection) {
            return new TransmissionConnectionVisual(modelBundle);
        }
        return null;
    }
}

