/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.af3.platform.hierarchic.ui.prototypes;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.af3.platform.hierarchic.utils.HierarchicPlatformModelElementFactory;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.extension.base.PrototypeProviderBase;
import org.fortiss.tooling.kernel.extension.data.PrototypeCategory;

public class PrototypeProvider
extends PrototypeProviderBase {
    private static boolean hideGenericHierarchicalArchitecture = false;

    protected void requestHideGenericHierarchicalArchitecture(boolean hideGenericHierarchicalArchitecture) {
        PrototypeProvider.hideGenericHierarchicalArchitecture |= hideGenericHierarchicalArchitecture;
    }

    protected void registerPrototypes() {
        this.setupPlatformArchitecturePrototypes();
    }

    public List<PrototypeCategory> getCategories() {
        if (hideGenericHierarchicalArchitecture && ((Object)((Object)this)).getClass().equals(PrototypeProvider.class)) {
            return Collections.emptyList();
        }
        return super.getCategories();
    }

    protected String getCategoryName() {
        return "Hierarchic Architecture";
    }

    protected void setupPlatformArchitecturePrototypes() {
        boolean expandByDefault = true;
        this.registerPrototypeCategory(this.getCategoryName(), expandByDefault);
        this.registerPrototype("Cluster");
        this.registerPrototype("Node");
        this.registerPrototype("OffChipNetworkPort");
        this.registerPrototype("OffChipNetworkInterface");
        this.registerPrototype("OffChipNetwork");
        this.registerPrototype("OffChipNetworkGateway");
        this.registerPrototype("OffChipNetworkRouter");
        this.registerPrototype("OffChipNetworkRouterPort");
        this.registerPrototype("Tile");
        this.registerPrototype("OnChipNetworkPort");
        this.registerPrototype("OnChipNetworkInterface");
        this.registerPrototype("OnChipNetwork");
        this.registerPrototype("OnChipOffChipGateway");
        this.registerPrototype("OnChipOffChipExport");
        this.registerPrototype("MemoryController");
        this.registerPrototype("MemoryControllerOut");
        this.registerPrototype("MemoryControllerIn");
        this.registerPrototype("Clock");
        this.registerPrototype("ClockOut");
        this.registerPrototype("ClockIn");
        this.registerPrototype("PowerSupply");
        this.registerPrototype("PowerOut");
        this.registerPrototype("PowerIn");
        this.registerPrototype("GeneralPurposeOutput");
        this.registerPrototype("GeneralPurposeInput");
        this.registerPrototype("WatchDog");
        this.registerPrototype("WatchDogOut");
        this.registerPrototype("WatchDogIn");
        this.registerPrototype("Sensor");
        this.registerPrototype("Actuator");
        this.registerPrototype("Core");
        this.registerPrototype("BusMasterPort");
        this.registerPrototype("BusMasterInterface");
        this.registerPrototype("BusSlavePort");
        this.registerPrototype("BusSlaveInterface");
        this.registerPrototype("BusOnChipNetworkExport");
        this.registerPrototype("Bus");
        this.registerPrototype("NetworkInterface");
        this.registerPrototype("RAM");
        this.registerPrototype("ROM");
        this.registerPrototype("Cache");
        this.registerPrototype("CacheIn");
        this.registerPrototype("CacheOut");
    }

    protected void registerPrototype(String name) {
        this.registerPrototype(name, name);
    }

    protected void registerPrototype(String typeName, String elementName) {
        ILayoutedModelElement prototypeObject = this.createPrototype(typeName, elementName);
        this.registerPrototype(elementName, prototypeObject, prototypeObject instanceof HierarchicElementBase);
    }

    private ILayoutedModelElement createPrototype(String typeName, String elementName) {
        ILayoutedModelElement prototypeObject = null;
        try {
            Method m = HierarchicPlatformModelElementFactory.class.getMethod("create" + typeName, String.class);
            if (m == null) {
                throw new Exception("registerPrototype: Error looking up factory method for type " + typeName);
            }
            Object rval = m.invoke(null, elementName);
            if (rval == null) {
                throw new Exception("registerPrototype: Error invoking factory method for type " + typeName);
            }
            prototypeObject = (ILayoutedModelElement)rval;
            LayoutDataUtils.setNodePosition((ILayoutedModelElement)prototypeObject, (int)0, (int)0);
            LayoutDataUtils.setConnectorPosition((ILayoutedModelElement)prototypeObject, (int)0, (int)0);
        }
        catch (Exception e) {
            System.out.println("Failed to register prototype for model element \"" + typeName + "\": " + e.getMessage());
        }
        return prototypeObject;
    }

    private void registerPrototype(String typeName, ILayoutedModelElement prototypeObject, boolean primary) {
        if (prototypeObject == null) {
            return;
        }
        if (primary) {
            this.registerPrimaryPrototype(typeName, (EObject)prototypeObject, this.getCategoryName());
        } else {
            this.registerPrototype(typeName, (EObject)prototypeObject, this.getCategoryName());
        }
    }
}

