/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.reuse.service.IReuseProvider;
import org.fortiss.tooling.ext.variability.model.OptionalVariationPointSpecification;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ReuseProviderBase<T extends EObject>
implements IReuseProvider<T> {
    @Override
    public boolean prepareReuseElementForLibrary(T reuseElement) {
        this.removeVariabilitySpecifications((EObject)reuseElement);
        this.removeExternalReferences((EObject)reuseElement);
        return true;
    }

    @Override
    public boolean updateReuseElement(T elementToBeUpdated, T newElement) {
        EcoreUtils.replaceEObjectReferences(elementToBeUpdated, newElement);
        EcoreUtil.replace(elementToBeUpdated, newElement);
        return true;
    }

    @Override
    public boolean setReuseElementName(T reuseElement, String name) {
        if (reuseElement instanceof INamedElement) {
            ((INamedElement)reuseElement).setName(name);
            return true;
        }
        return false;
    }

    @Override
    public String getReuseElementName(T reuseElement) {
        if (reuseElement instanceof INamedElement) {
            return ((INamedElement)reuseElement).getName();
        }
        return null;
    }

    @Override
    public boolean setReuseElementComment(T reuseElement, String comment) {
        if (reuseElement instanceof INamedCommentedElement) {
            ((INamedCommentedElement)reuseElement).setComment(comment);
            return true;
        }
        return false;
    }

    @Override
    public String getReuseElementComment(T reuseElement) {
        if (reuseElement instanceof INamedCommentedElement) {
            return ((INamedCommentedElement)reuseElement).getComment();
        }
        return null;
    }

    @Override
    public List<Class<? extends EObject>> getPossibleExternalReferenceClasses() {
        return new ArrayList<Class<? extends EObject>>();
    }

    private void removeVariabilitySpecifications(EObject element) {
        EList varSpecs = EcoreUtils.getChildrenWithType((EObject)element, OptionalVariationPointSpecification.class);
        for (OptionalVariationPointSpecification varSpec : varSpecs) {
            EObject varSpecContainer = varSpec.eContainer();
            if (varSpecContainer == null || !(varSpecContainer instanceof IModelElement)) continue;
            ((IModelElement)varSpecContainer).getSpecifications().remove((Object)varSpec);
        }
    }

    private void removeExternalReferences(EObject element) {
        HashSet<EObject> whitelist = new HashSet<EObject>((Collection<EObject>)EcoreUtils.getChildrenWithType((EObject)element, EObject.class));
        whitelist.add(element);
        this.removeReferences(element, whitelist);
    }

    private void removeReferences(EObject element, Set<EObject> whitelist) {
        for (EReference ref : element.eClass().getEAllReferences()) {
            Object refTarget = element.eGet((EStructuralFeature)ref);
            if (refTarget == null) continue;
            if (refTarget instanceof List) {
                List refTargetList = (List)refTarget;
                if (ref.isContainment()) {
                    refTargetList.stream().forEach(target -> this.removeReferences((EObject)target, whitelist));
                    continue;
                }
                refTargetList.removeIf(t -> !whitelist.contains(t));
                continue;
            }
            if (ref.isContainment()) {
                this.removeReferences((EObject)refTarget, whitelist);
                continue;
            }
            if (whitelist.contains(refTarget)) continue;
            element.eSet((EStructuralFeature)ref, null);
        }
    }
}

