/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.ext.reuse.service.IReuseProvider;
import org.fortiss.tooling.ext.reuse.service.IReuseProviderService;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.service.base.IObjectAware;

public class ReuseProviderService
extends EObjectAwareServiceBase<IReuseProvider<EObject>>
implements IReuseProviderService {
    private static final ReuseProviderService INSTANCE = new ReuseProviderService();
    private static List<Class<? extends EObject>> reuseElementClasses = new ArrayList<Class<? extends EObject>>();
    private static List<Class<? extends EObject>> possibleExternalReferenceClasses = new ArrayList<Class<? extends EObject>>();

    public static ReuseProviderService getInstance() {
        return INSTANCE;
    }

    public static List<Class<? extends EObject>> getReuseElementClasses() {
        return reuseElementClasses;
    }

    public static List<Class<? extends EObject>> getPossibleExternalReferenceClasses() {
        return possibleExternalReferenceClasses;
    }

    @Override
    public <T extends EObject> void registerReuseProvider(IReuseProvider<T> provider, Class<T> cls) {
        this.addHandler(cls, (IObjectAware)provider);
        if (!reuseElementClasses.contains(cls)) {
            reuseElementClasses.add(cls);
        }
        possibleExternalReferenceClasses.addAll(provider.getPossibleExternalReferenceClasses());
    }

    @Override
    public boolean prepareReuseElementForLibrary(EObject reuseElement) {
        IReuseProvider<EObject> provider = this.getReuseProvider(reuseElement);
        if (provider != null) {
            return provider.prepareReuseElementForLibrary(reuseElement);
        }
        return false;
    }

    @Override
    public boolean updateReuseElement(EObject elemToBeUpdated, EObject newElem) {
        IReuseProvider<EObject> provider = this.getReuseProvider(elemToBeUpdated);
        if (provider != null) {
            return provider.updateReuseElement(elemToBeUpdated, newElem);
        }
        return false;
    }

    @Override
    public boolean setReuseElementName(EObject reuseElement, String name) {
        IReuseProvider<EObject> provider = this.getReuseProvider(reuseElement);
        if (provider != null) {
            return provider.setReuseElementName(reuseElement, name);
        }
        return false;
    }

    @Override
    public String getReuseElementName(EObject reuseElement) {
        IReuseProvider<EObject> provider = this.getReuseProvider(reuseElement);
        if (provider != null) {
            return provider.getReuseElementName(reuseElement);
        }
        return null;
    }

    @Override
    public boolean setReuseElementComment(EObject reuseElement, String comment) {
        IReuseProvider<EObject> provider = this.getReuseProvider(reuseElement);
        if (provider != null) {
            return provider.setReuseElementComment(reuseElement, comment);
        }
        return false;
    }

    @Override
    public String getReuseElementComment(EObject reuseElement) {
        IReuseProvider<EObject> provider = this.getReuseProvider(reuseElement);
        if (provider != null) {
            return provider.getReuseElementComment(reuseElement);
        }
        return null;
    }

    public String getIntrospectionLabel() {
        return "Reuse Provider Service";
    }

    public String getIntrospectionDescription() {
        return "Service providing reuse methods for given (reuse) elements.";
    }

    protected String getExtensionPointName() {
        return "org.fortiss.tooling.ext.reuse.reuseProvider";
    }

    protected String getConfigurationElementName() {
        return "reuseProvider";
    }

    protected String getHandlerClassAttribute() {
        return "provider";
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    private IReuseProvider<EObject> getReuseProvider(EObject element) {
        List registeredHandlers = this.getRegisteredHandlers(element.getClass());
        if (registeredHandlers != null && registeredHandlers.size() == 1) {
            return (IReuseProvider)registeredHandlers.get(0);
        }
        return null;
    }
}

