/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.ext.reuse.ToolingReuseActivator;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.kernel.utils.EMFResourceUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class ReuseLibraryStorageManager {
    public static final String AF3_REUSE_DIRECTORY_NAME = "AF3-Reuse-Directory";
    public static final String AF3_REUSE_LIBRARY_FILES_EXTENSION = "af3_rlib";
    public static final IWorkspaceRoot WORKSPACE_ROOT = ResourcesPlugin.getWorkspace().getRoot();
    public static final File REUSE_PROJECT_DIR = new File(String.valueOf(WORKSPACE_ROOT.getLocation()) + File.separator + "AF3-Reuse-Directory");

    private static boolean isLibraryFile(File file) {
        return FilenameUtils.getExtension((String)file.getName()).equals(AF3_REUSE_LIBRARY_FILES_EXTENSION);
    }

    private static String getLibraryFolderName(ReuseLibrary library) {
        return library.getName() + "-" + library.getLibraryUUID();
    }

    private static String getLibraryFileName(ReuseLibrary library) {
        return library.getName() + ".af3_rlib";
    }

    private static IFolder getLibraryFolder(ReuseLibrary library) {
        String libFolderName = ReuseLibraryStorageManager.getLibraryFolderName(library);
        IProject project = WORKSPACE_ROOT.getProject(AF3_REUSE_DIRECTORY_NAME);
        return project.getFolder(libFolderName);
    }

    private static IFile getLibraryFile(ReuseLibrary library) {
        String libraryFolderName = ReuseLibraryStorageManager.getLibraryFolderName(library);
        String af3LibraryFileName = ReuseLibraryStorageManager.getLibraryFileName(library);
        return WORKSPACE_ROOT.getFile((IPath)new Path(AF3_REUSE_DIRECTORY_NAME + File.separator + libraryFolderName + File.separator + af3LibraryFileName));
    }

    public static List<ReuseLibrary> getAllSeparatelyStoredReuseLibraries() {
        ArrayList<ReuseLibrary> libraries = new ArrayList<ReuseLibrary>();
        if (REUSE_PROJECT_DIR.exists() && REUSE_PROJECT_DIR.isDirectory()) {
            File[] filesInDirectory;
            File[] fileArray = filesInDirectory = REUSE_PROJECT_DIR.listFiles();
            int n = filesInDirectory.length;
            int n2 = 0;
            while (n2 < n) {
                File directoryFile = fileArray[n2];
                if (directoryFile.isDirectory()) {
                    File[] fileArray2 = directoryFile.listFiles();
                    int n3 = fileArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File libraryFile = fileArray2[n4];
                        if (libraryFile.isFile() && ReuseLibraryStorageManager.isLibraryFile(libraryFile)) {
                            URI sourceFileURI = URI.createFileURI((String)libraryFile.getAbsolutePath());
                            ReuseLibrary library = (ReuseLibrary)EMFResourceUtils.loadModelFromFile((URI)sourceFileURI);
                            libraries.add(library);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return libraries;
    }

    public static boolean saveReuseLibrary(ReuseLibrary library) throws IOException, CoreException {
        return ReuseLibraryStorageManager.saveReuseLibrary(library, true);
    }

    public static boolean saveReuseLibrary(ReuseLibrary library, Boolean override) throws IOException, CoreException {
        ReuseLibraryStorageManager.ensureReuseProjectExists();
        IFolder folder = ReuseLibraryStorageManager.getLibraryFolder(library);
        if (!folder.exists()) {
            folder.create(0, true, null);
        }
        IFile file = ReuseLibraryStorageManager.getLibraryFile(library);
        if (override.booleanValue() || !file.exists()) {
            EMFResourceUtils.createNewEclipseWorkspaceProject((IFile)file, (EObject)library);
            return true;
        }
        return false;
    }

    private static void ensureReuseProjectExists() {
        String absoluteProjectPath = REUSE_PROJECT_DIR.getAbsolutePath();
        if (new File(absoluteProjectPath).isDirectory()) {
            return;
        }
        IProject project = WORKSPACE_ROOT.getProject(AF3_REUSE_DIRECTORY_NAME);
        try {
            if (project.exists()) {
                project.delete(false, (IProgressMonitor)new NullProgressMonitor());
            }
            project.create(null);
            project.open(null);
            EMFResourceUtils.refreshWorkspace();
        }
        catch (CoreException e) {
            LoggingUtils.error((Plugin)ToolingReuseActivator.getDefault(), (String)"Error during creating new project", (Throwable)e);
            LoggingUtils.showError((String)"Cannot create reuse project!");
        }
    }

    public static void deleteReuseLibraryFolder(ReuseLibrary library) throws CoreException {
        IFolder folder = ReuseLibraryStorageManager.getLibraryFolder(library);
        folder.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }
}

