/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.utils;

import java.time.ZonedDateTime;
import java.util.Random;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.ext.reuse.model.AF3ReuseFactory;
import org.fortiss.tooling.ext.reuse.model.ReuseElementSpec;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsManipulation;

public class ReuseLibraryModelElementFactory {
    private static String generateReuseUUID() {
        String uuid = EcoreUtil.generateUUID();
        Random randomStream = new Random();
        char replacementCharacter = (char)(randomStream.nextInt(26) + 97);
        return uuid.replace('-', replacementCharacter);
    }

    public static ReuseLibrary createReuseLibrary() {
        return ReuseLibraryModelElementFactory.createReuseLibrary("Reuse Library");
    }

    public static ReuseLibrary createReuseLibrary(String libraryName) {
        ReuseLibrary lib = AF3ReuseFactory.eINSTANCE.createReuseLibrary();
        lib.setName(libraryName);
        lib.setLibraryUUID(ReuseLibraryModelElementFactory.generateReuseUUID());
        return lib;
    }

    public static ReuseElementSpec createReuseElementSpec(EObject element, ReuseLibrary sourceLibrary) {
        ZonedDateTime now = ZonedDateTime.now();
        final ReuseElementSpec spec = AF3ReuseFactory.eINSTANCE.createReuseElementSpec();
        spec.setElementUUID(ReuseLibraryModelElementFactory.generateReuseUUID());
        spec.setElementName(ReuseLibraryUtilsBasics.getReuseElementName(element));
        spec.setElementHash(ReuseLibraryUtilsManipulation.createReuseHashAsString(element, now));
        spec.setSourceLibUUID(sourceLibrary.getLibraryUUID());
        spec.setSourceLibName(sourceLibrary.getName());
        spec.setLastUpdate(now);
        element.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                String featureName;
                Object feature = notification.getFeature();
                if (feature instanceof ENamedElement && !(featureName = ((ENamedElement)feature).getName()).equals("lastUpdate")) {
                    spec.setLastUpdate(ZonedDateTime.now());
                }
                super.notifyChanged(notification);
            }
        });
        return spec;
    }
}

