/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.utils;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.ext.reuse.model.ReuseElementSpec;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.service.IReuseProviderService;
import org.fortiss.tooling.ext.reuse.service.ReuseProviderService;
import org.fortiss.tooling.ext.reuse.storage.ReuseLibraryStorageManager;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class ReuseLibraryUtilsBasics {
    public static final DateTimeFormatter INTERNAL_REUSE_DATE_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;
    public static final DateTimeFormatter DISPLAY_REUSE_DATE_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME;

    public static boolean hasReusePossibility(EObject element) {
        for (Class<? extends EObject> cls : ReuseProviderService.getReuseElementClasses()) {
            if (!cls.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCorrectReuseElement(EObject element) {
        if (ReuseLibraryUtilsBasics.hasReusePossibility(element) && element instanceof IModelElement) {
            for (IModelElementSpecification spec : ((IModelElement)element).getSpecifications()) {
                String libID;
                if (!(spec instanceof ReuseElementSpec) || (libID = ((ReuseElementSpec)spec).getSourceLibUUID()) == null || libID.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCorrectReuseElementOrLibrary(EObject element) {
        return element instanceof ReuseLibrary || ReuseLibraryUtilsBasics.isCorrectReuseElement(element);
    }

    public static String getNameOfFirstRelatedLibrary(EObject element) {
        ReuseElementSpec spec = ReuseLibraryUtilsBasics.getFirstReuseSpec(element);
        if (spec != null) {
            return spec.getSourceLibName();
        }
        return "";
    }

    public static String getLibraryIDName(ReuseLibrary library) {
        return ReuseLibraryUtilsBasics.getLibraryIDNameFormat(library.getLibraryUUID(), library.getName());
    }

    public static String getLibraryIDNameFormat(String libraryUUID, String libraryName) {
        return libraryName + " (" + libraryUUID + ")";
    }

    public static String getReuseElementName(EObject element) {
        if (element instanceof ReuseLibrary) {
            return ((ReuseLibrary)element).getName();
        }
        String name = IReuseProviderService.getInstance().getReuseElementName(element);
        if (name == null) {
            name = element instanceof INamedElement ? ((INamedElement)element).getName() : element.toString();
        }
        return name;
    }

    public static boolean setReuseElementName(EObject element, String name) {
        if (element instanceof ReuseLibrary) {
            ((ReuseLibrary)element).setName(name);
            return true;
        }
        return IReuseProviderService.getInstance().setReuseElementName(element, name);
    }

    public static String getReuseElementComment(EObject element) {
        String comment = null;
        if (element instanceof ReuseLibrary) {
            comment = ((ReuseLibrary)element).getComment();
        } else {
            comment = IReuseProviderService.getInstance().getReuseElementComment(element);
            if (comment == null && element instanceof INamedCommentedElement) {
                comment = ((INamedCommentedElement)element).getComment();
            }
        }
        return comment == null ? "" : comment;
    }

    public static boolean setReuseElementComment(EObject element, String comment) {
        if (element instanceof ReuseLibrary) {
            ((ReuseLibrary)element).setComment(comment);
            return true;
        }
        return IReuseProviderService.getInstance().setReuseElementComment(element, comment);
    }

    public static String getFirstReuseElementUUID(EObject element) {
        List<String> allUUIDs = ReuseLibraryUtilsBasics.getAllReuseElementUUID(element);
        if (allUUIDs != null && !allUUIDs.isEmpty()) {
            return allUUIDs.get(0);
        }
        return "";
    }

    public static List<String> getAllReuseElementUUID(EObject element) {
        ArrayList<String> allUUIDs = new ArrayList<String>();
        if (element instanceof ReuseLibrary) {
            allUUIDs.add(((ReuseLibrary)element).getLibraryUUID());
        } else {
            List<ReuseElementSpec> specs = ReuseLibraryUtilsBasics.getAllReuseSpecs(element);
            for (ReuseElementSpec spec : specs) {
                allUUIDs.add(spec.getElementUUID());
            }
        }
        return allUUIDs;
    }

    public static String getReuseElementUUIDForLibrary(EObject element, ReuseLibrary library) {
        List<ReuseElementSpec> specs = ReuseLibraryUtilsBasics.getAllReuseSpecs(element);
        for (ReuseElementSpec spec : specs) {
            if (!spec.getSourceLibUUID().equals(library.getLibraryUUID())) continue;
            return spec.getElementUUID();
        }
        return "";
    }

    public static String getReuseElementHashForLibrary(EObject element, ReuseLibrary sourceLibrary) {
        String libraryUuid = sourceLibrary.getLibraryUUID();
        List<ReuseElementSpec> specs = ReuseLibraryUtilsBasics.getAllReuseSpecs(element);
        for (ReuseElementSpec spec : specs) {
            String referenceLibraryUuid = spec.getSourceLibUUID();
            if (!referenceLibraryUuid.equals(libraryUuid)) continue;
            return spec.getElementHash();
        }
        return "";
    }

    public static ZonedDateTime getReuseElementLastUpdate(EObject element) {
        List<ReuseElementSpec> specs = ReuseLibraryUtilsBasics.getAllReuseSpecs(element);
        if (specs != null && !specs.isEmpty()) {
            return specs.get(0).getLastUpdate();
        }
        return null;
    }

    public static String getReuseElementLastUpdateString(EObject element, boolean forDisplay) {
        ZonedDateTime updateDate = ReuseLibraryUtilsBasics.getReuseElementLastUpdate(element);
        return ReuseLibraryUtilsBasics.getDateAsString(updateDate, forDisplay);
    }

    public static String getDateAsString(ZonedDateTime date, boolean forDisplay) {
        if (date != null) {
            if (forDisplay) {
                return DISPLAY_REUSE_DATE_FORMATTER.format(date);
            }
            return INTERNAL_REUSE_DATE_FORMATTER.format(date);
        }
        return "";
    }

    public static void setReuseElementLastUpdate(EObject element, ZonedDateTime newDate) {
        for (ReuseElementSpec spec : ReuseLibraryUtilsBasics.getAllReuseSpecs(element)) {
            spec.setLastUpdate(newDate);
        }
    }

    public static void setReuseElementLastUpdateNow(EObject element) {
        ReuseLibraryUtilsBasics.setReuseElementLastUpdate(element, ZonedDateTime.now());
    }

    public static List<ReuseElementSpec> getAllReuseSpecs(EObject element) {
        ArrayList<ReuseElementSpec> specs = new ArrayList<ReuseElementSpec>();
        if (element instanceof IModelElement) {
            for (IModelElementSpecification spec : ((IModelElement)element).getSpecifications()) {
                if (!(spec instanceof ReuseElementSpec)) continue;
                specs.add((ReuseElementSpec)spec);
            }
        }
        return specs;
    }

    public static ReuseElementSpec getFirstReuseSpec(EObject element) {
        List<ReuseElementSpec> specs = ReuseLibraryUtilsBasics.getAllReuseSpecs(element);
        if (!specs.isEmpty()) {
            return specs.get(0);
        }
        return null;
    }

    public static int getNumberOfContainedReuseSpecs(EObject element) {
        return ReuseLibraryUtilsBasics.getAllReuseSpecs(element).size();
    }

    public static ReuseElementSpec getReuseSpecLinkedToThisLibraryElement(IModelElement projectElement, IModelElement libraryElement) {
        List<ReuseElementSpec> projectSpecs = ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)projectElement);
        List<ReuseElementSpec> librarySpecs = ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)libraryElement);
        if (librarySpecs.size() == 1) {
            ReuseElementSpec librarySpec = librarySpecs.get(0);
            for (ReuseElementSpec specToBeChecked : projectSpecs) {
                if (!specToBeChecked.getSourceLibUUID().equals(librarySpec.getSourceLibUUID()) || !specToBeChecked.getElementUUID().equals(librarySpec.getElementUUID())) continue;
                return specToBeChecked;
            }
        }
        return null;
    }

    public static List<ReuseLibrary> getAllLocalReuseLibraries() {
        return ReuseLibraryStorageManager.getAllSeparatelyStoredReuseLibraries();
    }

    public static ReuseLibrary getLocalReuseLibraryByID(String libraryUUID) {
        for (ReuseLibrary library : ReuseLibraryUtilsBasics.getAllLocalReuseLibraries()) {
            if (!libraryUUID.equals(library.getLibraryUUID())) continue;
            return library;
        }
        return null;
    }

    public static ReuseLibrary getFirstSourceLibraryOfElement(EObject element) {
        ReuseElementSpec spec = ReuseLibraryUtilsBasics.getFirstReuseSpec(element);
        if (spec != null) {
            String libraryUUID = spec.getSourceLibUUID();
            return ReuseLibraryUtilsBasics.getLocalReuseLibraryByID(libraryUUID);
        }
        return null;
    }

    public static List<ReuseLibrary> getAllSourceLibrariesOfElement(EObject element) {
        ArrayList<ReuseLibrary> foundLibraries = new ArrayList<ReuseLibrary>();
        List<ReuseElementSpec> reuseSpecs = ReuseLibraryUtilsBasics.getAllReuseSpecs(element);
        for (ReuseElementSpec reuseSpec : reuseSpecs) {
            String libraryUUID = reuseSpec.getSourceLibUUID();
            ReuseLibrary sourceLibrary = ReuseLibraryUtilsBasics.getLocalReuseLibraryByID(libraryUUID);
            if (sourceLibrary == null) continue;
            foundLibraries.add(sourceLibrary);
        }
        return foundLibraries;
    }

    public static EObject getElementInsideLibrary(ReuseLibrary library, String elementUUID) {
        for (EObject libraryElement : library.getReuseElementList()) {
            for (IModelElementSpecification spec : ((IModelElement)libraryElement).getSpecifications()) {
                if (!(spec instanceof ReuseElementSpec) || !((ReuseElementSpec)spec).getElementUUID().equals(elementUUID)) continue;
                return libraryElement;
            }
        }
        return null;
    }

    public static List<EObject> getExternalReferencesOfElement(EObject element) {
        ArrayList<EObject> references = new ArrayList<EObject>();
        for (Class<? extends EObject> referenceClass : ReuseProviderService.getPossibleExternalReferenceClasses()) {
            for (EObject reference : EcoreUtils.getChildrenWithType((EObject)element, referenceClass)) {
                references.add(reference);
            }
        }
        return references;
    }

    public static List<EObject> getAllUpdatedOrigins(EObject element) {
        ArrayList<EObject> updatedOrigins = new ArrayList<EObject>();
        List<ReuseLibrary> foundLibraries = ReuseLibraryUtilsBasics.getAllSourceLibrariesOfElement(element);
        for (ReuseLibrary sourceLibrary : foundLibraries) {
            String uuid = ReuseLibraryUtilsBasics.getReuseElementUUIDForLibrary(element, sourceLibrary);
            EObject originElementInLib = ReuseLibraryUtilsBasics.getElementInsideLibrary(sourceLibrary, uuid);
            String storedHashForThisLibrary = ReuseLibraryUtilsBasics.getReuseElementHashForLibrary(element, sourceLibrary);
            String currentHashForThisLibrary = ReuseLibraryUtilsBasics.getReuseElementHashForLibrary(originElementInLib, sourceLibrary);
            if (storedHashForThisLibrary.isEmpty() || currentHashForThisLibrary.isEmpty() || storedHashForThisLibrary.equals(currentHashForThisLibrary)) continue;
            updatedOrigins.add(originElementInLib);
        }
        return updatedOrigins;
    }

    public static boolean doesReuseElementExistWithContext(EObject element) {
        IPersistencyService ps = IPersistencyService.getInstance();
        ITopLevelElement context = ps.getTopLevelElementFor(element);
        return context != null;
    }
}

