/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.ext.reuse.utils;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.ext.reuse.ToolingReuseActivator;
import org.fortiss.tooling.ext.reuse.model.ReuseElementSpec;
import org.fortiss.tooling.ext.reuse.model.ReuseLibrary;
import org.fortiss.tooling.ext.reuse.service.IReuseProviderService;
import org.fortiss.tooling.ext.reuse.storage.ReuseLibraryStorageManager;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryModelElementFactory;
import org.fortiss.tooling.ext.reuse.utils.ReuseLibraryUtilsBasics;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;
import org.fortiss.tooling.kernel.utils.UniqueIDUtils;

public class ReuseLibraryUtilsManipulation {
    public static void fixIDs(EObject element) {
        EObject root = element;
        while (root.eContainer() != null) {
            root = root.eContainer();
        }
        UniqueIDUtils.removeDuplicateIds((EObject)root);
        UniqueIDUtils.generateMissingIDs((EObject)root, (int)UniqueIDUtils.getLargestID((EObject)root));
    }

    public static String createReuseHashAsString(EObject element, ZonedDateTime modifyDate) {
        if (element != null && modifyDate != null) {
            int hash = element.hashCode();
            String hashString = String.valueOf(hash) + "__" + ReuseLibraryUtilsBasics.getDateAsString(modifyDate, false);
            return hashString;
        }
        return null;
    }

    public static void removeNonMatchingConnections(IHierarchicElement target, IHierarchicElement source, Comparator<IConnector> connectorMatchComparator) {
        IConnector matchedConnector = null;
        for (IConnector targetConnector : target.getConnectors()) {
            boolean saveConnections = false;
            for (IConnector sourceConnector : source.getConnectors()) {
                if (connectorMatchComparator.compare(targetConnector, sourceConnector) != 0) continue;
                matchedConnector = sourceConnector;
                saveConnections = true;
                EcoreUtils.replaceEObjectReferences((EObject)targetConnector, (EObject)matchedConnector);
                break;
            }
            ArrayList<IConnection> connectionsToBeRemoved = new ArrayList<IConnection>();
            for (IConnection incoming : targetConnector.getIncoming()) {
                if (saveConnections) {
                    incoming.setTarget(matchedConnector);
                    continue;
                }
                connectionsToBeRemoved.add(incoming);
            }
            for (IConnection outgoing : targetConnector.getOutgoing()) {
                if (saveConnections) {
                    outgoing.setSource(matchedConnector);
                    continue;
                }
                connectionsToBeRemoved.add(outgoing);
            }
            for (IConnection connection : connectionsToBeRemoved) {
                EcoreUtil.delete((EObject)connection);
            }
            if (saveConnections) continue;
            for (EStructuralFeature.Setting setting : EcoreUtils.getAllReferencesSetting((EObject)targetConnector)) {
                EcoreUtil.delete((EObject)setting.getEObject());
            }
        }
    }

    public static void setupElementForLibrary(IModelElement element, ReuseElementSpec connectingSpec) {
        for (ReuseElementSpec spec : ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)element)) {
            if (connectingSpec.getElementUUID().equals(spec.getElementUUID()) && connectingSpec.getLastUpdate().equals(spec.getLastUpdate())) continue;
            element.getSpecifications().remove((Object)spec);
        }
        IReuseProviderService.getInstance().prepareReuseElementForLibrary((EObject)element);
    }

    public static EObject createElementForLibrary(EObject originalElement, ReuseLibrary library, String saveName) {
        ReuseElementSpec spec = ReuseLibraryUtilsManipulation.addReuseSpecToElement((IModelElement)originalElement, library);
        spec.setElementName(saveName);
        ReuseLibraryUtilsManipulation.fixIDs(originalElement);
        EObject newElementForLibrary = EcoreUtils.copy((EObject)originalElement);
        ReuseLibraryUtilsBasics.setReuseElementName(newElementForLibrary, saveName);
        ReuseLibraryUtilsManipulation.setupElementForLibrary((IModelElement)newElementForLibrary, spec);
        return newElementForLibrary;
    }

    public static ReuseElementSpec addReuseSpecToElement(IModelElement element, ReuseLibrary library) {
        ReuseElementSpec spec = ReuseLibraryModelElementFactory.createReuseElementSpec((EObject)element, library);
        element.getSpecifications().add((Object)spec);
        return spec;
    }

    public static void addElementToLibrary(EObject element, ReuseLibrary library) throws IOException, CoreException {
        library.getReuseElementList().add((Object)element);
        ReuseLibraryStorageManager.saveReuseLibrary(library);
    }

    public static ReuseLibrary createAndAddReuseLibrary(String libraryName) {
        if (libraryName == null || libraryName.equals("")) {
            return ReuseLibraryModelElementFactory.createReuseLibrary();
        }
        return ReuseLibraryModelElementFactory.createReuseLibrary(libraryName);
    }

    public static void replaceElementInLibrary(EObject originalElementInLibrary, EObject newElement, ReuseElementSpec referencingSpec, String newName) {
        ZonedDateTime now = ZonedDateTime.now();
        referencingSpec.setLastUpdate(now);
        referencingSpec.setElementName(newName);
        referencingSpec.setElementHash(ReuseLibraryUtilsManipulation.createReuseHashAsString(newElement, now));
        EObject newLibraryElement = EcoreUtils.copy((EObject)newElement);
        ReuseLibraryUtilsBasics.setReuseElementName(newLibraryElement, newName);
        ReuseLibraryUtilsManipulation.setupElementForLibrary((IModelElement)newLibraryElement, referencingSpec);
        EcoreUtil.replace((EObject)originalElementInLibrary, (EObject)newLibraryElement);
    }

    public static EObject replaceElementInProject(EObject elementInProject, EObject originalElementInLibrary, String newName, boolean keepAdditionalReferences) {
        if (originalElementInLibrary instanceof IModelElement && elementInProject instanceof IModelElement) {
            boolean success;
            IModelElement sourceElement = (IModelElement)EcoreUtils.copy((EObject)((IModelElement)originalElementInLibrary));
            IModelElement modelElementInProject = (IModelElement)elementInProject;
            List<ReuseElementSpec> specs = ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)sourceElement);
            ZonedDateTime now = ZonedDateTime.now();
            if (specs.size() != 1) {
                return null;
            }
            specs.get(0).setLastUpdate(now);
            ReuseLibraryUtilsBasics.setReuseElementName((EObject)sourceElement, newName);
            if (keepAdditionalReferences) {
                List<ReuseElementSpec> oldSpecs = ReuseLibraryUtilsBasics.getAllReuseSpecs((EObject)modelElementInProject);
                ReuseElementSpec mainSpec = ReuseLibraryUtilsBasics.getReuseSpecLinkedToThisLibraryElement(modelElementInProject, sourceElement);
                oldSpecs.remove(mainSpec);
                sourceElement.getSpecifications().addAll(oldSpecs);
            }
            if (success = IReuseProviderService.getInstance().updateReuseElement((EObject)modelElementInProject, (EObject)sourceElement)) {
                return sourceElement;
            }
        }
        return null;
    }

    public static void deleteReuseLibrary(ReuseLibrary library) {
        try {
            ReuseLibraryStorageManager.deleteReuseLibraryFolder(library);
        }
        catch (CoreException e) {
            LoggingUtils.error((Plugin)ToolingReuseActivator.getDefault(), (String)"Error during deleting reuse library folder", (Throwable)e);
            LoggingUtils.showError((String)("Cannot delete reuse library: " + ReuseLibraryUtilsBasics.getReuseElementName((EObject)library)));
        }
    }

    public static void deleteReuseElementInLibraryFile(EObject element, ReuseLibrary sourceLibrary) {
        EObject correctLibraryElement = null;
        EList<EObject> libraryElementList = sourceLibrary.getReuseElementList();
        for (EObject libraryElement : libraryElementList) {
            if (!ReuseLibraryUtilsBasics.getFirstReuseElementUUID(libraryElement).equals(ReuseLibraryUtilsBasics.getReuseElementUUIDForLibrary(element, sourceLibrary))) continue;
            correctLibraryElement = libraryElement;
            break;
        }
        if (correctLibraryElement == null) {
            return;
        }
        libraryElementList.remove(correctLibraryElement);
        try {
            ReuseLibraryStorageManager.saveReuseLibrary(sourceLibrary);
        }
        catch (IOException | CoreException e) {
            LoggingUtils.error((Plugin)ToolingReuseActivator.getDefault(), (String)"Error during removing reuse element from reuse library", (Throwable)e);
            LoggingUtils.showError((String)("Cannot remove reuse element: " + ReuseLibraryUtilsBasics.getReuseElementName(element) + " from this reuse library: " + ReuseLibraryUtilsBasics.getReuseElementName((EObject)sourceLibrary)));
        }
    }

    public static void deleteReuseElementInLibraryFile(EObject element) {
        ReuseLibrary sourceLibrary = ReuseLibraryUtilsBasics.getFirstSourceLibraryOfElement(element);
        if (sourceLibrary != null) {
            ReuseLibraryUtilsManipulation.deleteReuseElementInLibraryFile(element, sourceLibrary);
        }
    }

    public static void updateReuseElementFileWithName(EObject element, String newName, ReuseLibrary sourceLibrary) {
        if (element == null || newName == null || newName.isBlank()) {
            return;
        }
        boolean modifiedLibrary = false;
        ReuseLibrary libraryForDeletion = null;
        Object errorObject = "";
        if (element instanceof ReuseLibrary) {
            sourceLibrary = (ReuseLibrary)element;
            libraryForDeletion = (ReuseLibrary)EcoreUtils.copy((EObject)sourceLibrary);
            ReuseLibraryUtilsBasics.setReuseElementName((EObject)sourceLibrary, newName);
            for (EObject libraryElement : sourceLibrary.getReuseElementList()) {
                List<ReuseElementSpec> specList = ReuseLibraryUtilsBasics.getAllReuseSpecs(libraryElement);
                for (ReuseElementSpec reuseSpec : specList) {
                    reuseSpec.setSourceLibName(newName);
                }
            }
            errorObject = "reuse library '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)sourceLibrary) + "'";
            modifiedLibrary = true;
        } else {
            for (EObject libraryElement : sourceLibrary.getReuseElementList()) {
                if (!ReuseLibraryUtilsBasics.getFirstReuseElementUUID(libraryElement).equals(ReuseLibraryUtilsBasics.getReuseElementUUIDForLibrary(element, sourceLibrary))) continue;
                ReuseLibraryUtilsBasics.setReuseElementName(libraryElement, newName);
                List<ReuseElementSpec> specList = ReuseLibraryUtilsBasics.getAllReuseSpecs(libraryElement);
                for (ReuseElementSpec reuseSpec : specList) {
                    reuseSpec.setElementName(newName);
                }
                ReuseLibraryUtilsBasics.setReuseElementLastUpdateNow(libraryElement);
                errorObject = "reuse element '" + ReuseLibraryUtilsBasics.getReuseElementName(libraryElement) + "' in reuse library '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)sourceLibrary) + "'";
                modifiedLibrary = true;
                break;
            }
        }
        if (modifiedLibrary) {
            try {
                ReuseLibraryStorageManager.saveReuseLibrary(sourceLibrary);
                if (libraryForDeletion != null) {
                    ReuseLibraryStorageManager.deleteReuseLibraryFolder(libraryForDeletion);
                }
            }
            catch (IOException | CoreException e) {
                LoggingUtils.error((Plugin)ToolingReuseActivator.getDefault(), (String)("Error during renaming " + (String)errorObject), (Throwable)e);
                LoggingUtils.showError((String)("Cannot rename " + (String)errorObject));
            }
        }
    }

    public static void updateReuseElementFileWithName(EObject element, String newName) {
        if (element instanceof ReuseLibrary) {
            ReuseLibraryUtilsManipulation.updateReuseElementFileWithName(element, newName, null);
        } else {
            ReuseLibrary sourceLibrary = ReuseLibraryUtilsBasics.getFirstSourceLibraryOfElement(element);
            if (sourceLibrary != null) {
                ReuseLibraryUtilsManipulation.updateReuseElementFileWithName(element, newName, sourceLibrary);
            }
        }
    }

    public static void updateReuseElementFileWithComment(EObject element, String newComment, ReuseLibrary sourceLibrary) {
        boolean modifiedLibrary = false;
        Object errorObject = "";
        if (element instanceof ReuseLibrary) {
            sourceLibrary = (ReuseLibrary)element;
            ReuseLibraryUtilsBasics.setReuseElementComment((EObject)sourceLibrary, newComment);
            errorObject = "reuse library '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)sourceLibrary) + "'";
            modifiedLibrary = true;
        } else {
            EList<EObject> libraryElementList = sourceLibrary.getReuseElementList();
            for (EObject libraryElement : libraryElementList) {
                if (!ReuseLibraryUtilsBasics.getFirstReuseElementUUID(libraryElement).equals(ReuseLibraryUtilsBasics.getReuseElementUUIDForLibrary(element, sourceLibrary))) continue;
                ReuseLibraryUtilsBasics.setReuseElementComment(libraryElement, newComment);
                ReuseLibraryUtilsBasics.setReuseElementLastUpdateNow(libraryElement);
                errorObject = "reuse element '" + ReuseLibraryUtilsBasics.getReuseElementName(libraryElement) + "' in reuse library '" + ReuseLibraryUtilsBasics.getReuseElementName((EObject)sourceLibrary) + "'";
                modifiedLibrary = true;
                break;
            }
        }
        if (modifiedLibrary) {
            try {
                ReuseLibraryStorageManager.saveReuseLibrary(sourceLibrary);
            }
            catch (IOException | CoreException e) {
                LoggingUtils.error((Plugin)ToolingReuseActivator.getDefault(), (String)("Error during modifying " + (String)errorObject), (Throwable)e);
                LoggingUtils.showError((String)("Cannot modify " + (String)errorObject));
            }
        }
    }

    public static void updateReuseElementFileWithComment(EObject element, String newComment) {
        if (element instanceof ReuseLibrary) {
            ReuseLibraryUtilsManipulation.updateReuseElementFileWithComment(element, newComment, null);
        } else {
            ReuseLibrary sourceLibrary = ReuseLibraryUtilsBasics.getFirstSourceLibraryOfElement(element);
            if (sourceLibrary != null) {
                ReuseLibraryUtilsManipulation.updateReuseElementFileWithComment(element, newComment, sourceLibrary);
            }
        }
    }
}

