/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.af3.tools.diagram;

import eu.fbk.af3.tools.diagram.ComponentDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;

public class DiagramDescriptor {
    public String name;
    public int width = 0;
    public int height = 0;
    public String url;
    public String format;
    public String description;
    public ComponentDescriptor componentDescriptor;
    public Map<String, String> specificationTag = new Hashtable<String, String>();
    public Map<String, String> specifications = new Hashtable<String, String>();
    public List<DiagramDescriptor> children = new ArrayList<DiagramDescriptor>();

    public void createNewSpecification(String key, String tag) {
        this.specificationTag.put(key, tag);
    }

    public List<DiagramDescriptor> getFlatDescriptorList() {
        ArrayList<DiagramDescriptor> descriptors = new ArrayList<DiagramDescriptor>();
        descriptors.add(this);
        return this.getFlatDescriptorList(this, descriptors);
    }

    private List<DiagramDescriptor> getFlatDescriptorList(DiagramDescriptor parentDescriptor, List<DiagramDescriptor> descriptors) {
        for (DiagramDescriptor descriptor : parentDescriptor.children) {
            descriptors.add(descriptor);
            this.getFlatDescriptorList(descriptor, descriptors);
        }
        return descriptors;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> diagramDescriptorMap = new HashMap<String, Object>();
        String urlNoExtension = FilenameUtils.removeExtension((String)this.url).replace("%20", " ");
        diagramDescriptorMap.put("url_no_extension", urlNoExtension);
        diagramDescriptorMap.put("url", this.url);
        diagramDescriptorMap.put("name", this.name);
        diagramDescriptorMap.put("children", this.getRecursivelyDiagramDescriptors(this));
        if (this.componentDescriptor != null) {
            diagramDescriptorMap.put("component", this.componentDescriptor.serialize());
        }
        for (String specificationKey : this.specifications.keySet()) {
            String tag = this.specificationTag.get(specificationKey);
            String specification = this.specifications.get(specificationKey);
            diagramDescriptorMap.put(tag, specification);
        }
        return diagramDescriptorMap;
    }

    private List<Object> getRecursivelyDiagramDescriptors(DiagramDescriptor parentDescriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        for (DiagramDescriptor descriptor : parentDescriptor.children) {
            descriptors.add(descriptor.serialize());
        }
        return descriptors;
    }
}

