/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.af3.tools.diagram;

import eu.fbk.af3.tools.diagram.Activator;
import eu.fbk.af3.tools.diagram.DiagramDescriptor;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class DocumentGenerator {
    private String name;
    private String type;
    private DiagramDescriptor diagramDescriptor;
    private Template template;

    public boolean init(String name, String type) {
        try {
            DocumentType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            LoggingUtils.error((Plugin)Activator.getDefault(), (String)("Unsupported document type: " + type));
            return false;
        }
        this.name = name;
        this.type = type;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        try {
            ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(this.getClass(), "templates");
            cfg.setTemplateLoader((TemplateLoader)classTemplateLoader);
            this.template = cfg.getTemplate(type + "_model.ftl");
        }
        catch (IOException e) {
            LoggingUtils.error((Plugin)Activator.getDefault(), (String)e.toString());
            return false;
        }
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return true;
    }

    public void setDiagramDescriptor(DiagramDescriptor diagramDescriptor) {
        this.diagramDescriptor = diagramDescriptor;
    }

    /*
     * WARNING - void declaration
     */
    public void generate(String directoryName) {
        HashMap<String, Object> documentMap = new HashMap<String, Object>();
        documentMap.put("title", "Project: " + this.name);
        documentMap.put("descriptors", this.getDiagramDescriptors(this.diagramDescriptor));
        ArrayList<Map<String, Object>> diagrams = new ArrayList<Map<String, Object>>();
        documentMap.put("diagrams", diagrams);
        for (DiagramDescriptor diagramDescriptor : this.diagramDescriptor.getFlatDescriptorList()) {
            diagrams.add(diagramDescriptor.serialize());
        }
        try {
            Throwable throwable = null;
            Iterator<DiagramDescriptor> iterator = null;
            try (FileWriter out = new FileWriter(directoryName + File.separator + "document." + this.type);){
                this.template.process(documentMap, (Writer)out);
            }
            catch (Throwable throwable2) {
                void var4_10;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_10;
            }
        }
        catch (Exception exception) {
            LoggingUtils.error((Plugin)Activator.getDefault(), (String)exception.toString());
        }
    }

    private List<Object> getDiagramDescriptors(DiagramDescriptor descriptor) {
        ArrayList<Object> descriptors = new ArrayList<Object>();
        descriptors.add(descriptor.serialize());
        return descriptors;
    }

    public static enum DocumentType {
        html,
        tex;


        public static String[] getValuesAsStringArray() {
            String[] names = new String[DocumentType.values().length];
            int index = 0;
            DocumentType[] documentTypeArray = DocumentType.values();
            int n = documentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DocumentType state = documentTypeArray[n2];
                names[index++] = state.name();
                ++n2;
            }
            return names;
        }
    }
}

