/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.af3.tools.diagram.svg;

import eu.fbk.af3.tools.diagram.svg.SVGBasicObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGComponent
extends SVGBasicObject {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    public SVGComponent(Document doc, String label, int x, int y, int width, int height) {
        super(doc, label);
        this.element = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setLabelX(x + width / 2);
        this.setLabelY(y + height / 2);
        this.setLabelFontWeight("bold");
        this.setLabelFontSize("16px");
        this.fillColor = "white";
    }

    @Override
    public Element getElement() {
        this.element.setAttributeNS(null, "x", String.valueOf(this.x));
        this.element.setAttributeNS(null, "y", String.valueOf(this.y));
        this.element.setAttributeNS(null, "width", String.valueOf(this.width));
        this.element.setAttributeNS(null, "height", String.valueOf(this.height));
        this.element.setAttributeNS(null, "rx", "8");
        this.element.setAttributeNS(null, "ry", "8");
        this.element.setAttributeNS(null, "stroke", this.strokeColor);
        this.element.setAttributeNS(null, "stroke-width", String.valueOf(this.strokeWidth));
        this.element.setAttributeNS(null, "fill", this.fillColor);
        return this.element;
    }

    @Override
    public Element getLabelElement() {
        super.getLabelElement();
        this.labelElement.setAttributeNS(null, "text-anchor", "middle");
        this.labelElement.setAttributeNS(null, "alignment-baseline", "middle");
        return this.labelElement;
    }
}

