/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.types.EMFTypeMap;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class AnnotationEntry
implements Comparable<AnnotationEntry> {
    private IModelElement modelElement;
    private EMFTypeMap<IAnnotatedSpecification, IAnnotationValueProvider<IAnnotatedSpecification>> providerSpecMapping = new EMFTypeMap();
    private List<IAnnotatedSpecification> specificationsList = new ArrayList<IAnnotatedSpecification>();

    public AnnotationEntry(IModelElement modelElement) {
        this.modelElement = modelElement;
    }

    public boolean isEmpty() {
        return this.specificationsList.isEmpty();
    }

    private boolean isOperationEnabled(IAnnotatedSpecification specification) {
        return specification != null && specification.getSpecificationOf() != null;
    }

    private void raiseCouldNotFindAnnotationValueProviderException(Class<? extends IAnnotatedSpecification> clazz) throws Exception {
        throw new Exception("Could not find an AnnotationValueProvider for " + clazz.toString());
    }

    public void addNewSpecification(IAnnotationValueProvider<IAnnotatedSpecification> provider, IAnnotatedSpecification spec) {
        this.providerSpecMapping.put(spec.getClass(), provider);
        this.specificationsList.add(spec);
    }

    public String getSpecificationAnnotationName(Class<? extends IAnnotatedSpecification> clazz) {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            return this.getAnnotationValueProvider(clazz).getAnnotationName(specification);
        }
        return null;
    }

    public void setSpecificationAnnotationName(String name, Class<? extends IAnnotatedSpecification> clazz) throws Exception {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            this.getAnnotationValueProvider(clazz).setAnnotationName(name, specification);
        }
        this.raiseCouldNotFindAnnotationValueProviderException(clazz);
    }

    public boolean isHidden(Class<? extends IAnnotatedSpecification> clazz) {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            return this.getAnnotationValueProvider(clazz).isHidden(specification);
        }
        return true;
    }

    public boolean canEdit(Class<? extends IAnnotatedSpecification> clazz) {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            return this.getAnnotationValueProvider(clazz).canEdit(specification);
        }
        return false;
    }

    public <V> V getSpecificationValue(Class<? extends IAnnotatedSpecification> clazz) {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            try {
                return (V)this.getAnnotationValueProvider(clazz).getAnnotationValue(specification);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public <V> void setSpecificationValue(V value, Class<? extends IAnnotatedSpecification> clazz) throws Exception {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            this.getAnnotationValueProvider(clazz).setAnnotationValue(value, specification);
        } else {
            this.raiseCouldNotFindAnnotationValueProviderException(clazz);
        }
    }

    public void setSpecificationValue(String value, Class<? extends IAnnotatedSpecification> clazz) throws Exception {
        IAnnotatedSpecification specification = this.getSpecification(clazz);
        if (this.isOperationEnabled(specification)) {
            this.getAnnotationValueProvider(clazz).setAnnotationValue(value, specification);
        } else {
            this.raiseCouldNotFindAnnotationValueProviderException(clazz);
        }
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public List<IAnnotatedSpecification> getSpecificationsList() {
        return this.specificationsList;
    }

    public IAnnotationValueProvider<IAnnotatedSpecification> getAnnotationValueProvider(Class<? extends IAnnotatedSpecification> clazz) {
        return (IAnnotationValueProvider)this.providerSpecMapping.get(clazz);
    }

    public <T extends IAnnotatedSpecification> T getSpecification(Class<T> clazz) {
        for (IAnnotatedSpecification s : this.specificationsList) {
            if (!clazz.isInstance(s)) continue;
            return (T)s;
        }
        return null;
    }

    @Override
    public int compareTo(AnnotationEntry otherEntry) {
        int otherLevel;
        IModelElement otherModelElement = otherEntry.getModelElement();
        IModelElement thisModelElement = this.getModelElement();
        int thisLevel = EcoreUtils.getModelElementLevel((EObject)thisModelElement);
        if (thisLevel != (otherLevel = EcoreUtils.getModelElementLevel((EObject)otherModelElement))) {
            return Integer.valueOf(thisLevel).compareTo(otherLevel);
        }
        if (thisModelElement instanceof INamedElement && otherModelElement instanceof INamedElement) {
            INamedElement thisNamed = (INamedElement)thisModelElement;
            INamedElement otherNamed = (INamedElement)otherModelElement;
            int stringCompare = thisNamed.getName().compareTo(otherNamed.getName());
            if (!thisNamed.getName().matches("^[a-zA-Z0-9^].*") && otherNamed.getName().matches("^[a-zA-Z0-9].*")) {
                return stringCompare * -1;
            }
            if (!otherNamed.getName().matches("^[a-zA-Z0-9^].*") && thisNamed.getName().matches("^[a-zA-Z0-9].*")) {
                return stringCompare * -1;
            }
            return stringCompare;
        }
        return 0;
    }
}

