/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.ToolingKernelActivator;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.introspection.IIntrospectiveKernelService;
import org.fortiss.tooling.kernel.service.IKernelIntrospectionSystemService;
import org.fortiss.tooling.kernel.service.IPersistencyService;
import org.fortiss.tooling.kernel.service.base.EObjectAwareServiceBase;
import org.fortiss.tooling.kernel.service.types.EMFTypeMap;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class AnnotationValueService
extends EObjectAwareServiceBase<IAnnotationValueProvider<IAnnotatedSpecification>>
implements IAnnotationValueService {
    public static final AnnotationValueService INSTANCE = new AnnotationValueService();
    private static final String EXTENSION_POINT_NAME = "org.fortiss.tooling.base.annotation";
    private static final String CONFIGURATION_ELEMENT_NAME = "annotation";
    private static final String HANDLER_CLASS_ATTRIBUTE_NAME = "binding";
    private EMFTypeMap<EObject, List<IAnnotationValueProvider<IAnnotatedSpecification>>> valueProviderCache = new EMFTypeMap();
    private Map<IModelElement, AnnotationEntry> annotationEntryCache = new HashMap<IModelElement, AnnotationEntry>();

    public static AnnotationValueService getInstance() {
        return INSTANCE;
    }

    public void startService() {
        IKernelIntrospectionSystemService.getInstance().registerService((IIntrospectiveKernelService)this);
    }

    public String getIntrospectionDescription() {
        return "The Annotation Value Service contributes model element attributes that always exist if the corresponding model element is instantiated.";
    }

    public String getIntrospectionLabel() {
        return "Annotation Value Service";
    }

    public List<IAnnotationValueProvider<IAnnotatedSpecification>> getRegisteredHandlers(Class<?> modelElementClass) {
        ArrayList<IAnnotationValueProvider<IAnnotatedSpecification>> valueProviderList = (ArrayList<IAnnotationValueProvider<IAnnotatedSpecification>>)this.valueProviderCache.get(modelElementClass);
        if (valueProviderList != null) {
            return valueProviderList;
        }
        HashSet valueProviderSet = new HashSet();
        LinkedList q = new LinkedList();
        q.add(modelElementClass);
        while (!q.isEmpty()) {
            Class superClass;
            Class current = (Class)q.poll();
            List currentHandlers = super.getRegisteredHandlers(current);
            if (currentHandlers != null) {
                valueProviderSet.addAll(currentHandlers);
            }
            if ((superClass = current.getSuperclass()) != null && superClass != Object.class) {
                q.add(superClass);
            }
            Class<?>[] classArray = current.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> iface = classArray[n2];
                q.add(iface);
                ++n2;
            }
        }
        valueProviderList = new ArrayList<IAnnotationValueProvider<IAnnotatedSpecification>>(valueProviderSet);
        this.valueProviderCache.put(modelElementClass, valueProviderList);
        return valueProviderList;
    }

    private void prepareAnnotationEntry(IModelElement element, AnnotationEntry entry) {
        List<IAnnotationValueProvider<IAnnotatedSpecification>> registeredHandlers = this.getRegisteredHandlers(element.getClass());
        for (IAnnotationValueProvider<IAnnotatedSpecification> annotationProvider : registeredHandlers) {
            IAnnotatedSpecification annotatedSpecification = (IAnnotatedSpecification)EcoreUtils.pickFirstInstanceOf(annotationProvider.getAnnotationClazz(), element.getSpecifications());
            if (annotatedSpecification == null) {
                try {
                    annotatedSpecification = annotationProvider.getAnnotatedSpecificationForModelElement(element);
                }
                catch (Exception ex) {
                    LoggingUtils.error((Plugin)ToolingKernelActivator.getDefault(), (String)("Error instantating new annotation: createAnnotatedSpecificationForModelElement() failed for " + String.valueOf(annotationProvider.getAnnotationClazz()) + "."), (Throwable)ex);
                    return;
                }
            }
            entry.addNewSpecification(annotationProvider, annotatedSpecification);
        }
    }

    @Override
    public void instantiateAnnotations(IModelElement element) {
        this.getAnnotationEntry(element, false);
    }

    @Override
    public boolean requiresAnnotationInstantiation(IModelElement element) {
        List<IAnnotationValueProvider<IAnnotatedSpecification>> registeredHandlers = this.getRegisteredHandlers(element.getClass());
        if (registeredHandlers == null) {
            return false;
        }
        for (IAnnotationValueProvider<IAnnotatedSpecification> annotationProvider : registeredHandlers) {
            IAnnotatedSpecification annotatedSpecification = (IAnnotatedSpecification)EcoreUtils.pickFirstInstanceOf(annotationProvider.getAnnotationClazz(), element.getSpecifications());
            if (annotatedSpecification != null) continue;
            return true;
        }
        return false;
    }

    private AnnotationEntry getAnnotationEntry(final IModelElement element, boolean invokedFromGuiContext) {
        AnnotationEntry cachedResult = this.annotationEntryCache.get(element);
        if (cachedResult != null) {
            return cachedResult;
        }
        if (element == null) {
            return null;
        }
        final AnnotationEntry result = new AnnotationEntry(element);
        ITopLevelElement modelContext = IPersistencyService.getInstance().getTopLevelElementFor((EObject)element);
        if (this.requiresAnnotationInstantiation(element) && modelContext != null) {
            modelContext.runAsCommand(new Runnable(){

                @Override
                public void run() {
                    AnnotationValueService.this.prepareAnnotationEntry(element, result);
                }
            });
        } else {
            this.prepareAnnotationEntry(element, result);
        }
        if (invokedFromGuiContext) {
            this.annotationEntryCache.put(element, result);
        }
        return result;
    }

    @Override
    public AnnotationEntry getAnnotationEntry(IModelElement element) {
        return this.getAnnotationEntry(element, true);
    }

    protected String getExtensionPointName() {
        return EXTENSION_POINT_NAME;
    }

    protected String getConfigurationElementName() {
        return CONFIGURATION_ELEMENT_NAME;
    }

    protected String getHandlerClassAttribute() {
        return HANDLER_CLASS_ATTRIBUTE_NAME;
    }

    protected boolean requiresUniqueHandler() {
        return false;
    }
}

