/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation.valueprovider;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureValueProviderBase;
import org.fortiss.tooling.base.model.element.IDerivedAnnotation;

public abstract class DerivedAnnotationValueProviderBase<T extends IDerivedAnnotation<?>>
extends EStructuralFeatureValueProviderBase<T> {
    private boolean isEditableByUser;

    public DerivedAnnotationValueProviderBase(EClass annotatedSpecificationEClass, EAttribute eAttribute, boolean isEditableByUser) {
        super(annotatedSpecificationEClass, new EStructuralFeatureDescriptor(eAttribute));
        this.isEditableByUser = isEditableByUser;
    }

    public DerivedAnnotationValueProviderBase(EClass annotatedSpecificationEClass, EReference eReference, EStructuralFeatureDescriptor.EReferenceScope eReferenceScope, boolean isEditableByUser) {
        super(annotatedSpecificationEClass, new EStructuralFeatureDescriptor(eReference, eReferenceScope));
        this.isEditableByUser = isEditableByUser;
    }

    public DerivedAnnotationValueProviderBase(EClass annotatedSpecificationEClass, EAttribute eAttribute) {
        this(annotatedSpecificationEClass, eAttribute, false);
    }

    public DerivedAnnotationValueProviderBase(EClass annotatedSpecificationEClass, EReference eReference, EStructuralFeatureDescriptor.EReferenceScope eReferenceScope) {
        this(annotatedSpecificationEClass, eReference, eReferenceScope, false);
    }

    public DerivedAnnotationValueProviderBase(EClass annotatedSpecificationEClass) {
        super(annotatedSpecificationEClass, new EStructuralFeatureDescriptor(null));
        this.isEditableByUser = false;
    }

    public boolean isEditableByUser() {
        return this.isEditableByUser;
    }

    @Override
    public boolean canEdit(T specification) {
        boolean derivedValueAvailable;
        if (!this.isEditableByUser) {
            return false;
        }
        boolean preferDerivedValue = this.isEditableByUser && !specification.isUserAnnotatedValuePreferred();
        boolean bl = derivedValueAvailable = specification.getDerivedValue() != null;
        if (preferDerivedValue && derivedValueAvailable) {
            return false;
        }
        return super.canEdit(specification);
    }

    @Override
    public <U> U getAnnotationValue(T specification) {
        Object calculatedValue = specification.getValue();
        if (calculatedValue != null) {
            return (U)calculatedValue;
        }
        return super.getAnnotationValue(specification);
    }

    @Override
    public <U> void setAnnotationValue(U value, T specification) throws Exception {
        if (specification.getDerivedFeature() != null) {
            if (value instanceof String) {
                this.setAnnotationValueFromString((String)value, specification);
            } else {
                specification.eSet(specification.getDerivedFeature(), value);
            }
            return;
        }
        super.setAnnotationValue(value, specification);
    }
}

