/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation.valueprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IDerivedAnnotation;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.model.IProjectRootElement;
import org.fortiss.tooling.kernel.utils.KernelModelElementUtils;

public class EStructuralFeatureDescriptor {
    private EStructuralFeature eStructuralFeature;
    private EReferenceScope eReferenceScope;
    private Map<Class<?>, EList<EEnumLiteral>> enumLiteralFilter;

    public EStructuralFeatureDescriptor(EAttribute eAttribute) {
        this.eStructuralFeature = eAttribute;
        this.eReferenceScope = null;
    }

    public EStructuralFeatureDescriptor(EAttribute eAttribute, Map<Class<?>, EList<EEnumLiteral>> enumLiterals) {
        this(eAttribute);
        this.enumLiteralFilter = new HashMap();
        if (enumLiterals != null && !enumLiterals.isEmpty()) {
            this.enumLiteralFilter.putAll(enumLiterals);
        }
    }

    public EStructuralFeatureDescriptor(EReference eReference, EReferenceScope eReferenceScope) {
        this.eStructuralFeature = eReference;
        this.eReferenceScope = eReferenceScope;
    }

    public EStructuralFeature getEStructuralFeature(IAnnotatedSpecification specification) {
        EStructuralFeature derivedFeature;
        if (specification instanceof IDerivedAnnotation && (derivedFeature = ((IDerivedAnnotation)specification).getDerivedFeature()) != null) {
            return derivedFeature;
        }
        return this.eStructuralFeature;
    }

    public EReferenceScope getEReferenceScope() {
        return this.eReferenceScope;
    }

    public boolean isAvailableObject(EObject obj, IAnnotatedSpecification specification, EObject modelElement) {
        boolean rootElementSeen = false;
        while (obj != null) {
            if (obj instanceof IProjectRootElement) {
                if (rootElementSeen) {
                    return false;
                }
                rootElementSeen = true;
            }
            obj = obj.eContainer();
        }
        return true;
    }

    public EObject getValueRootElement(IModelElement modelElement) {
        switch (this.getEReferenceScope()) {
            case PROJECT: {
                IProjectRootElement rootElement = (IProjectRootElement)KernelModelElementUtils.getParentElement((EObject)modelElement, IProjectRootElement.class, (boolean)true);
                return rootElement != null ? rootElement.eContainer() : null;
            }
            case MODEL: {
                return KernelModelElementUtils.getParentElement((EObject)modelElement, IProjectRootElement.class, (boolean)true);
            }
            case SUB_MODEL: 
            case STRICT_SUB_MODEL: {
                return modelElement;
            }
        }
        throw new RuntimeException("Unsupported reference scope: " + String.valueOf((Object)this.getEReferenceScope()));
    }

    public EClassifier getEType(IAnnotatedSpecification specification) {
        EStructuralFeature esf = this.getEStructuralFeature(specification);
        return esf != null ? esf.getEType() : null;
    }

    public EList<EEnumLiteral> getEnumLiterals(EEnum eType, EObject modelElement) {
        EList<EEnumLiteral> rval = null;
        if (this.enumLiteralFilter != null) {
            Class<?> filterForClass = null;
            for (Class<?> filterClass : this.enumLiteralFilter.keySet()) {
                if (!filterClass.isAssignableFrom(modelElement.getClass())) continue;
                filterForClass = filterClass;
            }
            rval = this.enumLiteralFilter.get(filterForClass);
        }
        return rval != null ? rval : eType.getELiterals();
    }

    public static enum EReferenceScope {
        PROJECT,
        MODEL,
        SUB_MODEL,
        STRICT_SUB_MODEL;

    }
}

