/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation.valueprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.tooling.base.ToolingBaseActivator;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.ValueProviderBase;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public abstract class EStructuralFeatureValueProviderBase<T extends IAnnotatedSpecification>
extends ValueProviderBase<T> {
    private final EStructuralFeatureDescriptor structuralFeatureDescriptor;

    public EStructuralFeatureValueProviderBase(EClass annotatedSpecificationEClass, EAttribute eAttribute) {
        super(annotatedSpecificationEClass);
        this.structuralFeatureDescriptor = new EStructuralFeatureDescriptor(eAttribute);
    }

    public EStructuralFeatureValueProviderBase(EClass annotatedSpecificationEClass, EReference eReference, EStructuralFeatureDescriptor.EReferenceScope eReferenceScope) {
        super(annotatedSpecificationEClass);
        this.structuralFeatureDescriptor = new EStructuralFeatureDescriptor(eReference, eReferenceScope);
    }

    public EStructuralFeatureValueProviderBase(EClass annotatedSpecificationEClass) {
        this(annotatedSpecificationEClass, EStructuralFeatureDescriptor.EReferenceScope.MODEL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EStructuralFeatureValueProviderBase(EClass annotatedSpecificationEClass, EStructuralFeatureDescriptor.EReferenceScope eReferenceScope) {
        super(annotatedSpecificationEClass);
        EList featureList = annotatedSpecificationEClass.getEStructuralFeatures();
        if (featureList.size() > 1) {
            throw new RuntimeException("Annotation class " + String.valueOf(annotatedSpecificationEClass) + " must not contain more than one structural feature.");
        }
        if (featureList.size() == 1) {
            EStructuralFeature structuralFeature = (EStructuralFeature)featureList.get(0);
            if (structuralFeature instanceof EAttribute) {
                this.structuralFeatureDescriptor = new EStructuralFeatureDescriptor((EAttribute)structuralFeature);
                return;
            } else {
                if (!(structuralFeature instanceof EReference)) throw new RuntimeException("Unsupported EStructuralFeature specialization: " + String.valueOf(structuralFeature));
                this.structuralFeatureDescriptor = new EStructuralFeatureDescriptor((EReference)structuralFeature, eReferenceScope);
            }
            return;
        } else {
            this.structuralFeatureDescriptor = null;
        }
    }

    public EStructuralFeatureValueProviderBase(EClass annotatedSpecificationEClass, EStructuralFeatureDescriptor structuralFeatureDescriptor) {
        super(annotatedSpecificationEClass);
        this.structuralFeatureDescriptor = structuralFeatureDescriptor;
    }

    @Override
    public EStructuralFeatureDescriptor getEStructuralFeatureDescriptor() {
        return this.structuralFeatureDescriptor;
    }

    private EFactory getEFactory(EStructuralFeature structuralFeature) {
        return structuralFeature.getEType().getEPackage().getEFactoryInstance();
    }

    protected <V> void setAnnotationValueFromString(String value, T specification) throws Exception {
        EStructuralFeature structuralFeature = this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification);
        if (structuralFeature instanceof EAttribute) {
            EFactory eFactory = this.getEFactory(structuralFeature);
            EDataType eAttributeType = ((EAttribute)structuralFeature).getEAttributeType();
            try {
                specification.eSet(structuralFeature, eFactory.createFromString(eAttributeType, value));
            }
            catch (Exception exception) {}
        } else {
            throw new Exception("setAnnotationValueFromString(String, T) is only availabe for EAttributes. Use setAnnotationValue(U value, T specification) instead.");
        }
    }

    private void setAnnotationValueFromString(Collection<String> collection, T specification) throws Exception {
        BasicEList values;
        EStructuralFeature structuralFeature = this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification);
        if (structuralFeature instanceof EAttribute) {
            EFactory eFactory = this.getEFactory(structuralFeature);
            EDataType eAttributeType = ((EAttribute)structuralFeature).getEAttributeType();
            values = new BasicEList();
            for (String s : collection) {
                Object o = null;
                try {
                    o = eFactory.createFromString(eAttributeType, s);
                }
                catch (Exception e) {
                    LoggingUtils.error((Plugin)ToolingBaseActivator.getDefault(), (String)("Could not convert " + (s != null ? s : "<null>") + " to datatype " + String.valueOf(eAttributeType) + "."), (Throwable)e);
                }
                if (o == null) continue;
                values.add(o);
            }
        } else {
            throw new Exception("setAnnotationValueFromString(Collection<String>, T) is only availabe for EAttributes.");
        }
        specification.eSet(structuralFeature, (Object)values);
    }

    @Override
    public boolean canEdit(T specification) {
        return true;
    }

    @Override
    public <U> void setAnnotationValue(U value, T specification) throws Exception {
        EStructuralFeature eStructuralFeature = this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification);
        if (value instanceof String) {
            if (((String)value).isEmpty()) {
                value = this.determineCurrentAnnotationValueAndUpdateInputChoice((String)value, specification);
            }
            if (value != null) {
                this.setAnnotationValueFromString((String)value, specification);
            } else {
                specification.eUnset(eStructuralFeature);
            }
        } else if (eStructuralFeature.isMany()) {
            List<String> collection;
            List<String> list = collection = value instanceof Collection ? (List<String>)value : Collections.singletonList(value);
            if (collection.isEmpty()) {
                specification.eSet(eStructuralFeature, Collections.emptyList());
            } else if (collection.iterator().next() instanceof String) {
                this.setAnnotationValueFromString(collection, specification);
            } else {
                specification.eSet(eStructuralFeature, collection);
            }
        } else if (value != null) {
            specification.eSet(eStructuralFeature, value);
        } else {
            specification.eUnset(eStructuralFeature);
        }
    }

    @Override
    public void setAnnotationValue(String value, T specification) throws Exception {
        EStructuralFeature structuralFeature;
        String rval;
        if ((value == null || value.isEmpty()) && (rval = this.determineCurrentAnnotationValueAndUpdateInputChoice(value, specification)) != null) {
            value = rval;
        }
        if (!((structuralFeature = this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification)) instanceof EAttribute)) {
            throw new Exception("setAnnotationValue(String, T) is not supported / has not been implemented for the annotation type " + structuralFeature.getEType().getName() + "(specification class: " + String.valueOf(specification.getClass()) + ").");
        }
        this.setAnnotationValueFromString(value, specification);
    }

    @Override
    public <U> U getAnnotationValue(T specification) {
        return (U)specification.eGet(this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification));
    }

    protected Object createStructuralFeatureInstance() throws Exception {
        EStructuralFeature structuralFeature = this.getEStructuralFeatureDescriptor().getEStructuralFeature(null);
        if (structuralFeature == null) {
            return null;
        }
        if (structuralFeature instanceof EAttribute) {
            EFactory factory = this.getEFactory(structuralFeature);
            EDataType attributeEDataType = ((EAttribute)structuralFeature).getEAttributeType();
            String defaultValueLiteral = structuralFeature.getDefaultValueLiteral();
            Object defaultValue = null;
            defaultValue = defaultValueLiteral != null ? factory.createFromString(attributeEDataType, defaultValueLiteral) : attributeEDataType.getDefaultValue();
            if (structuralFeature.getUpperBound() == 1) {
                return defaultValue;
            }
            ArrayList<Object> valueList = new ArrayList<Object>();
            int i = 0;
            while (i < structuralFeature.getLowerBound()) {
                valueList.add(defaultValue);
                ++i;
            }
            return valueList;
        }
        if (structuralFeature instanceof EReference) {
            return null;
        }
        throw new Exception("createStructuralFeatureInstance() is not supported / has not been implemented for the annotation type " + structuralFeature.getName() + ".");
    }

    @Override
    protected void decorateAnnotationSpecification(T specification) throws Exception {
        Object structuralFeatureVal = this.createStructuralFeatureInstance();
        if (structuralFeatureVal != null) {
            EStructuralFeature eStructuralFeature = this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification);
            specification.eSet(eStructuralFeature, structuralFeatureVal);
        }
    }
}

