/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation.valueprovider;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.conqat.lib.commons.collections.Pair;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.annotation.valueprovider.AnnotationInstSpec;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.BaseMathUtils;
import org.fortiss.tooling.kernel.service.base.IEObjectAware;

public interface IAnnotationValueProvider<T extends IAnnotatedSpecification>
extends IEObjectAware<IModelElement> {
    public String getAnnotationName(T var1);

    public boolean setAnnotationName(String var1, T var2);

    public boolean isHidden(T var1);

    public boolean canEdit(T var1);

    public <U> U getAnnotationValue(T var1);

    public <U> void setAnnotationValue(U var1, T var2) throws Exception;

    public void setAnnotationValue(String var1, T var2) throws Exception;

    public T getAnnotatedSpecificationForModelElement(IModelElement var1) throws Exception;

    public Class<T> getAnnotationClazz();

    public List<Class<? extends EObject>> excludeModelElementTypeFromAnnotatedSpecification();

    public EStructuralFeatureDescriptor getEStructuralFeatureDescriptor();

    public AnnotationActions<T> getContextMenuEntries(T var1);

    public static class AnnotationAction<T extends IAnnotatedSpecification>
    extends Pair<AnnotationActionEntry, BiConsumer<AnnotationInstSpec<T>, AnnotationActionParameters<T>>> {
        public AnnotationAction(AnnotationActionEntry first, BiConsumer<AnnotationInstSpec<T>, AnnotationActionParameters<T>> second) {
            super((Object)first, second);
        }
    }

    public static class AnnotationActionEntry {
        private String entryName;
        private ActionScope scope;
        private AnnotationActionInputParameters inputParameters;
        private AnnotationActionReqInputParameters inputReqParameters;
        private boolean isWrite;

        public AnnotationActionEntry(String entryName, ActionScope scope, boolean isWrite) {
            this.entryName = entryName;
            this.scope = scope;
            this.isWrite = isWrite;
        }

        public AnnotationActionEntry(String entryName, ActionScope scope, boolean isWrite, AnnotationActionReqInputParameters inputReqParameters) {
            this(entryName, scope, isWrite);
            this.inputReqParameters = inputReqParameters;
        }

        public String getName() {
            return this.entryName;
        }

        public ActionScope getScope() {
            return this.scope;
        }

        public AnnotationActionInputParameters getInputParameters() {
            return this.inputParameters;
        }

        public AnnotationActionReqInputParameters getRequiredInputParameters() {
            return this.inputReqParameters;
        }

        public boolean isWrite() {
            return this.isWrite;
        }

        public static enum ActionScope {
            ALL_VISIBLE_ITEMS,
            SINGLE_ITEM;

        }
    }

    public static class AnnotationActionInputParameter
    extends Pair<String, Class<?>> {
        public AnnotationActionInputParameter(String first, Class<?> second) {
            super((Object)first, second);
        }
    }

    public static class AnnotationActionInputParameters {
        Map<AnnotationActionInputParameter, Object> parameterValueMap = new LinkedHashMap<AnnotationActionInputParameter, Object>();

        public void add(String parameterName, Class<?> parameterType) {
            this.parameterValueMap.put(new AnnotationActionInputParameter(parameterName, parameterType), null);
        }

        public <T extends Number> void put(String parameterName, Class<T> parameterType, T value) {
            this.parameterValueMap.put(new AnnotationActionInputParameter(parameterName, parameterType), value);
        }

        public <T> T get(String parameterName, Class<T> parameterType) {
            Object retVal = this.parameterValueMap.get((Object)new AnnotationActionInputParameter(parameterName, parameterType));
            if (retVal != null && parameterType.isAssignableFrom(retVal.getClass()) || retVal instanceof Number && BaseMathUtils.isExpectedType((Number)retVal, parameterType)) {
                return (T)retVal;
            }
            return null;
        }

        public Set<AnnotationActionInputParameter> keySet() {
            return this.parameterValueMap.keySet();
        }
    }

    public static class AnnotationActionParameters<T extends IAnnotatedSpecification> {
        private T annotation;
        private AnnotationActionInputParameters inputParameters;

        public AnnotationActionParameters(T annotation, AnnotationActionInputParameters inputParameters) {
            this.annotation = annotation;
            this.inputParameters = inputParameters;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public AnnotationActionInputParameters getInputParameters() {
            return this.inputParameters;
        }
    }

    public static class AnnotationActionReqInputParameter
    extends Pair<String, EStructuralFeatureDescriptor> {
        public AnnotationActionReqInputParameter(String first, EStructuralFeatureDescriptor second) {
            super((Object)first, (Object)second);
        }
    }

    public static class AnnotationActionReqInputParameters
    extends ArrayList<AnnotationActionReqInputParameter> {
    }

    public static class AnnotationActions<T extends IAnnotatedSpecification>
    extends ArrayList<AnnotationAction<T>> {
    }
}

