/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.annotation.valueprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.fortiss.tooling.base.ToolingBaseActivator;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.valueprovider.AnnotationInstSpec;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public abstract class ValueProviderBase<T extends IAnnotatedSpecification>
implements IAnnotationValueProvider<T> {
    protected final EClass annotatedSpecificationEClass;
    private List<String> fixedInputChoice;
    private Collection<String> currentInputChoice;
    private AnnotationInstSpec<T> copiedAnnotation;

    public ValueProviderBase(EClass annotatedSpecificationEClass) {
        this.annotatedSpecificationEClass = annotatedSpecificationEClass;
    }

    @Override
    public boolean setAnnotationName(String name, T specification) {
        return false;
    }

    @Override
    public boolean isHidden(T specification) {
        return false;
    }

    @Override
    public void setAnnotationValue(String value, T specification) throws Exception {
        throw new Exception("setAnnotationValue(String) is not supported / has not been implemented for annotations of type " + String.valueOf(specification.getClass()));
    }

    @Override
    public <U> void setAnnotationValue(U value, T specification) throws Exception {
        throw new Exception("setAnnotationValue(U) is not supported / has not been implemented for annotations of type " + String.valueOf(specification.getClass()));
    }

    @Override
    public List<Class<? extends EObject>> excludeModelElementTypeFromAnnotatedSpecification() {
        return null;
    }

    protected void decorateAnnotationSpecification(T specification) throws Exception {
    }

    @Override
    public T getAnnotatedSpecificationForModelElement(IModelElement element) throws Exception {
        Class instanceClass = this.annotatedSpecificationEClass.getInstanceClass();
        IAnnotatedSpecification rval = (IAnnotatedSpecification)EcoreUtils.pickFirstInstanceOf((Class)instanceClass, element.getSpecifications());
        if (rval != null) {
            return (T)rval;
        }
        EFactory eFactory = this.annotatedSpecificationEClass.getEPackage().getEFactoryInstance();
        IAnnotatedSpecification specification = (IAnnotatedSpecification)eFactory.create(this.annotatedSpecificationEClass);
        this.decorateAnnotationSpecification(specification);
        element.addSpecification(specification);
        return (T)specification;
    }

    @Override
    public Class<T> getAnnotationClazz() {
        return this.annotatedSpecificationEClass.getInstanceClass();
    }

    public List<String> getFixedInputChoice() {
        return this.fixedInputChoice;
    }

    public void setFixedInputChoice(List<String> fixedInputChoice) {
        this.fixedInputChoice = fixedInputChoice;
    }

    public Collection<String> getCurrentInputChoice() {
        return this.currentInputChoice;
    }

    public void setCurrentInputChoice(Collection<String> currentInputChoice) {
        this.currentInputChoice = currentInputChoice;
    }

    protected String determineCurrentAnnotationValueAndUpdateInputChoice(String newValue, T specification) throws Exception {
        boolean noValue;
        boolean bl = noValue = newValue == null || newValue.isEmpty();
        if (noValue && this.currentInputChoice != null && !this.currentInputChoice.isEmpty()) {
            if (this.currentInputChoice.size() == 1) {
                return this.currentInputChoice.iterator().next();
            }
            String currentValue = (String)this.getAnnotationValue(specification);
            Iterator<String> iter = this.currentInputChoice.iterator();
            if (iter.next().equals(currentValue)) {
                String rval = iter.next();
                this.currentInputChoice.remove(currentValue);
                return rval;
            }
            String rval = null;
            for (String s : this.currentInputChoice) {
                if (s != null && s.equals(currentValue)) {
                    this.currentInputChoice.remove(currentValue);
                    return rval;
                }
                rval = s;
            }
            return rval;
        }
        return null;
    }

    @Override
    public IAnnotationValueProvider.AnnotationActions<T> getContextMenuEntries(T specification) {
        IAnnotationValueProvider.AnnotationActions retList = new IAnnotationValueProvider.AnnotationActions();
        EStructuralFeature eType = null;
        if (this.getEStructuralFeatureDescriptor() != null) {
            eType = this.getEStructuralFeatureDescriptor().getEStructuralFeature((IAnnotatedSpecification)specification);
        }
        boolean isManyRef = eType instanceof EReference && ((EReference)eType).isMany();
        retList.add(this.createCopyAction());
        retList.addAll(this.createPasteActions(isManyRef, false));
        if (isManyRef) {
            retList.addAll(this.createPasteActions(isManyRef, true));
        }
        return retList;
    }

    private IAnnotationValueProvider.AnnotationAction<T> createCopyAction() {
        BiConsumer copyAction = (spec, parameters) -> {
            this.copiedAnnotation = spec;
        };
        IAnnotationValueProvider.AnnotationActionEntry copyDescriptor = new IAnnotationValueProvider.AnnotationActionEntry("Copy", IAnnotationValueProvider.AnnotationActionEntry.ActionScope.SINGLE_ITEM, false);
        return new IAnnotationValueProvider.AnnotationAction(copyDescriptor, copyAction);
    }

    private List<IAnnotationValueProvider.AnnotationAction<T>> createPasteActions(boolean isManyRef, boolean doReplace) {
        ArrayList<IAnnotationValueProvider.AnnotationAction<T>> pasteActions = new ArrayList<IAnnotationValueProvider.AnnotationAction<T>>();
        BiConsumer pasteAction = (spec, parameters) -> {
            if (this.copiedAnnotation == null) {
                return;
            }
            AnnotationEntry annEntry = this.copiedAnnotation.getEntry();
            Object copiedValue = annEntry.getSpecificationValue(this.copiedAnnotation.getAnnotatedSpecificationType());
            Object pasteAnnotation = parameters.getAnnotation();
            if (pasteAnnotation != null) {
                try {
                    this.pasteValue(isManyRef, doReplace, copiedValue, pasteAnnotation);
                }
                catch (Exception e) {
                    LoggingUtils.error((Plugin)ToolingBaseActivator.getDefault(), (String)("Could not set the value of the annotation " + pasteAnnotation.getName() + " when trying to propagate the value form the selected annotation."), (Throwable)e);
                }
            }
        };
        String pasteSuffix = !isManyRef ? "" : (doReplace ? " (replace)" : " (append)");
        IAnnotationValueProvider.AnnotationActionEntry pasteDescriptor = new IAnnotationValueProvider.AnnotationActionEntry("Paste" + pasteSuffix, IAnnotationValueProvider.AnnotationActionEntry.ActionScope.SINGLE_ITEM, true);
        pasteActions.add(new IAnnotationValueProvider.AnnotationAction(pasteDescriptor, pasteAction));
        IAnnotationValueProvider.AnnotationActionEntry pasteAllDescriptor = new IAnnotationValueProvider.AnnotationActionEntry("Paste to all" + pasteSuffix, IAnnotationValueProvider.AnnotationActionEntry.ActionScope.ALL_VISIBLE_ITEMS, true);
        pasteActions.add(new IAnnotationValueProvider.AnnotationAction(pasteAllDescriptor, pasteAction));
        return pasteActions;
    }

    private void pasteValue(boolean isManyRef, boolean doReplace, Object copiedValue, T pasteAnnotation) throws Exception {
        if (isManyRef) {
            BasicEList castedList = new BasicEList((Collection)((EList)copiedValue));
            castedList.removeIf(r -> !this.canPaste((EObject)r, pasteAnnotation));
            copiedValue = castedList;
        } else if (copiedValue instanceof EReference && !this.canPaste((EObject)((EReference)copiedValue), pasteAnnotation)) {
            return;
        }
        if (!isManyRef || doReplace) {
            this.setAnnotationValue(copiedValue, pasteAnnotation);
        } else {
            ArrayList appendList = new ArrayList();
            appendList.addAll((Collection)this.getAnnotationValue(pasteAnnotation));
            appendList.addAll((List)copiedValue);
            this.setAnnotationValue(appendList, pasteAnnotation);
        }
    }

    private boolean canPaste(EObject refObj, T pasteAnnotation) {
        EStructuralFeatureDescriptor featurDescr = this.getEStructuralFeatureDescriptor();
        return featurDescr.isAvailableObject(refObj, (IAnnotatedSpecification)pasteAnnotation, pasteAnnotation.getSpecificationOf());
    }

    public void updateInputChoice(Object viewerInput, Class<T> clazz) {
        List<String> fixedInputChoice = this.getFixedInputChoice();
        if (fixedInputChoice == null || !fixedInputChoice.isEmpty()) {
            this.setCurrentInputChoice(fixedInputChoice);
        } else if (!(viewerInput instanceof Set) || ((Set)viewerInput).isEmpty() || !(((Set)viewerInput).iterator().next() instanceof AnnotationEntry)) {
            this.setCurrentInputChoice(null);
        } else {
            AnnotationEntry annotationEntry = (AnnotationEntry)((Set)viewerInput).iterator().next();
            IModelElement root = annotationEntry.getModelElement();
            while (root.eContainer() != null) {
                root = root.eContainer();
            }
            TreeSet<String> choices = new TreeSet<String>();
            for (IAnnotatedSpecification specification : EcoreUtils.getChildrenWithType((EObject)root, clazz)) {
                Object annotationValue;
                try {
                    annotationValue = this.getAnnotationValue(specification);
                }
                catch (Exception e) {
                    annotationValue = null;
                }
                if (annotationValue == null) continue;
                choices.add(annotationValue.toString());
            }
            this.setCurrentInputChoice(choices);
        }
    }
}

