/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.compose;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.dnd.ConnectionDragContext;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.IConnectionCompositor;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

public abstract class ConnectionCompositorBase<HE extends IHierarchicElement, S extends EObject, T extends EObject>
implements IConnectionCompositor<HE, S, T> {
    protected abstract IConnection createConnection();

    protected IConnection createConnection(IConnector source, IConnector target, HE parent, ITopLevelElement topElement) {
        IConnection connection = this.createConnection();
        if (topElement != null) {
            topElement.prepareIDs((EObject)connection);
        }
        parent.getConnections().add((Object)connection);
        boolean swap = false;
        if (source instanceof EntryConnectorBase) {
            swap = target instanceof EntryConnectorBase ? source.eContainer() != target.eContainer().eContainer() : target instanceof ExitConnectorBase;
        } else if (source instanceof ExitConnectorBase && target instanceof ExitConnectorBase) {
            swap = source.eContainer() == target.eContainer().eContainer();
        }
        connection.setSource(swap ? target : source);
        connection.setTarget(swap ? source : target);
        return connection;
    }

    public boolean reconnect(EObject connection, S source, T target, IConnectionCompositionContext context) {
        return false;
    }

    public boolean canReconnect(EObject connection, S source, T target, IConnectionCompositionContext context) {
        return false;
    }

    public boolean canDisconnect(EObject connection) {
        return false;
    }

    public boolean disconnect(EObject connection) {
        if (connection instanceof IConnection) {
            EcoreUtil.delete((EObject)connection);
            return true;
        }
        return false;
    }

    protected boolean canConnectInternally(S source, T target) {
        return false;
    }

    protected void createNewSourceDropContext(IHierarchicElement container, IConnectionCompositionContext context, EObject connected) {
        boolean isDragCtx = context instanceof ConnectionDragContext;
        ElementDropContext drop = isDragCtx ? ((ConnectionDragContext)context).getSourceDropContext() : null;
        IElementCompositorService.getInstance().compose((EObject)container, connected, (IElementCompositionContext)drop);
    }

    protected void createNewTargetDropContext(IHierarchicElement container, IConnectionCompositionContext context, EObject contained) {
        boolean isDragCtx = context instanceof ConnectionDragContext;
        ElementDropContext drop = isDragCtx ? ((ConnectionDragContext)context).getTargetDropContext() : null;
        IElementCompositorService.getInstance().compose((EObject)container, contained, (IElementCompositionContext)drop);
    }

    protected boolean sameParent(IHierarchicElement hierarchicalElement, IConnector connector) {
        return hierarchicalElement.eContainer() == connector.eContainer();
    }

    protected void avoidDuplicateConnectorName(IHierarchicElement container, IConnector connector) {
        String orig = ((INamedElement)connector).getName();
        if (this.sameName(container, connector, orig)) {
            int num = 1;
            while (this.sameName(container, connector, orig + num)) {
                ++num;
            }
            ((INamedElement)connector).setName(orig + num);
        } else {
            ((INamedElement)connector).setName(orig);
        }
    }

    private boolean sameName(IHierarchicElement container, IConnector connector, String name) {
        for (IConnector sibling : container.getConnectors()) {
            if (sibling == connector || !((INamedElement)sibling).getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

