/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.compose;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.compose.ConnectionCompositorBase;
import org.fortiss.tooling.base.dnd.ConnectionDragContext;
import org.fortiss.tooling.base.model.base.ConnectionSegmentBase;
import org.fortiss.tooling.base.model.base.ConnectorBase;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.kernel.extension.data.IConnectionCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public abstract class ConnectorConnectionCompositorBase<HE extends IHierarchicElement, S extends IConnector, T extends IConnector>
extends ConnectionCompositorBase<HE, S, T> {
    public boolean canConnect(S source, T target, HE parent, IConnectionCompositionContext context) {
        ConnectionDragContext dc;
        if (!this.allowInternalFeedback() && context instanceof ConnectionDragContext && (dc = (ConnectionDragContext)context).isSourceFreeConnector() && dc.isTargetFreeConnector()) {
            return false;
        }
        if (source instanceof EntryConnectorBase) {
            if (target instanceof EntryConnectorBase) {
                return this.checkEntryEntry((EntryConnectorBase)source, (EntryConnectorBase)target, null);
            }
            if (target instanceof ExitConnectorBase) {
                return this.checkExitEntry((ExitConnectorBase)target, (EntryConnectorBase)source, null);
            }
        } else if (source instanceof ExitConnectorBase) {
            if (target instanceof EntryConnectorBase) {
                return this.checkExitEntry((ExitConnectorBase)source, (EntryConnectorBase)target, null);
            }
            if (target instanceof ExitConnectorBase) {
                return this.checkExitExit((ExitConnectorBase)source, (ExitConnectorBase)target, null);
            }
        }
        return false;
    }

    private boolean checkEntryEntry(EntryConnectorBase source, EntryConnectorBase target, EObject connection) {
        boolean swapped = false;
        if (source.eContainer().eContainer() == target.eContainer()) {
            EntryConnectorBase temp = source;
            source = target;
            target = temp;
            swapped = true;
        }
        if (swapped || source.eContainer() == target.eContainer().eContainer()) {
            return this.checkSourceOut(source, connection) && this.checkTargetIn(target, connection);
        }
        return false;
    }

    private boolean checkExitEntry(ExitConnectorBase source, EntryConnectorBase target, EObject connection) {
        if (source.eContainer().eContainer() == target.eContainer().eContainer()) {
            return this.checkSourceOut(source, connection) && this.checkTargetIn(target, connection);
        }
        return false;
    }

    private boolean checkExitExit(ExitConnectorBase source, ExitConnectorBase target, EObject connection) {
        boolean swapped = false;
        if (source.eContainer() == target.eContainer().eContainer()) {
            ExitConnectorBase temp = source;
            source = target;
            target = temp;
            swapped = true;
        }
        if (swapped || source.eContainer().eContainer() == target.eContainer()) {
            return this.checkSourceOut(source, connection) && this.checkTargetIn(target, connection);
        }
        return false;
    }

    private boolean checkSourceOut(ConnectorBase source, EObject connection) {
        return source.getOutgoing().size() == 0 || connection instanceof ConnectionSegmentBase && ((ConnectionSegmentBase)connection).getSource() == source || this.allowOneToMany();
    }

    private boolean checkTargetIn(ConnectorBase target, EObject connection) {
        return target.getIncoming().size() == 0 || connection instanceof ConnectionSegmentBase && ((ConnectionSegmentBase)connection).getTarget() == target || this.allowManyToOne();
    }

    public boolean connect(S source, T target, HE parent, IConnectionCompositionContext context) {
        ITopLevelElement modelContext = IPersistencyService.getInstance().getTopLevelElementFor(source);
        this.createConnection((IConnector)source, (IConnector)target, parent, modelContext);
        return true;
    }

    protected boolean allowOneToMany() {
        return true;
    }

    protected boolean allowManyToOne() {
        return true;
    }

    protected boolean allowInternalFeedback() {
        return false;
    }
}

