/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.compose;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.compose.ModelElementCompositorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IHierarchicElementContainer;
import org.fortiss.tooling.kernel.service.IConnectionCompositorService;
import org.fortiss.tooling.kernel.service.IElementCompositorService;

public abstract class HierarchicElementCompositorBase<HE extends IHierarchicElementContainer>
extends ModelElementCompositorBase<HE> {
    @Override
    public final boolean decompose(EObject contained) {
        return this.iterateDecompose(contained) && this.decomposeSpecific(contained);
    }

    @Override
    protected boolean iterateDecompose(EObject contained) {
        super.iterateDecompose(contained);
        if (contained instanceof IHierarchicElementContainer && !this.iterateDecomposeSubelements((IHierarchicElementContainer)contained)) {
            return false;
        }
        if (contained instanceof IHierarchicElement) {
            IHierarchicElement he = (IHierarchicElement)contained;
            if (!this.iterateDecomposeConnections(he.getConnections())) {
                return false;
            }
            if (!this.iterateDecomposeConnectors((IHierarchicElement)contained)) {
                return false;
            }
        }
        if (contained instanceof IConnector) {
            IConnector connector = (IConnector)contained;
            if (!this.iterateDecomposeConnections(connector.getIncoming())) {
                return false;
            }
            if (!this.iterateDecomposeConnections(connector.getOutgoing())) {
                return false;
            }
        }
        return this.decomposeSpecific(contained);
    }

    private boolean iterateDecomposeSubelements(IHierarchicElementContainer contained) {
        ArrayList<IHierarchicElement> list = new ArrayList<IHierarchicElement>((Collection<IHierarchicElement>)contained.getContainedElements());
        for (IHierarchicElement subelement : list) {
            if (this.decomposeSubelement(subelement)) continue;
            return false;
        }
        return true;
    }

    private boolean iterateDecomposeConnections(EList<IConnection> connectionsList) {
        ArrayList<IConnection> list = new ArrayList<IConnection>((Collection<IConnection>)connectionsList);
        for (IConnection conn : list) {
            if (this.decomposeConnection(conn)) continue;
            return false;
        }
        return true;
    }

    private boolean iterateDecomposeConnectors(IHierarchicElement contained) {
        ArrayList<IConnector> list = new ArrayList<IConnector>((Collection<IConnector>)contained.getConnectors());
        for (IConnector c : list) {
            if (this.decomposeConnector(c)) continue;
            return false;
        }
        return true;
    }

    protected boolean decomposeSubelement(IHierarchicElement element) {
        if (IElementCompositorService.getInstance().canDecompose((EObject)element)) {
            return IElementCompositorService.getInstance().decompose((EObject)element);
        }
        EcoreUtil.delete((EObject)element, (boolean)true);
        return true;
    }

    protected boolean decomposeConnector(IConnector element) {
        ArrayList<IConnection> list = new ArrayList<IConnection>((Collection<IConnection>)element.getIncoming());
        list.addAll((Collection<IConnection>)element.getOutgoing());
        for (IConnection conn : list) {
            if (IConnectionCompositorService.getInstance().disconnect((EObject)conn)) continue;
            return false;
        }
        if (IElementCompositorService.getInstance().canDecompose((EObject)element)) {
            return IElementCompositorService.getInstance().decompose((EObject)element);
        }
        EcoreUtil.delete((EObject)element, (boolean)true);
        return true;
    }

    protected boolean decomposeConnection(IConnection conn) {
        return IConnectionCompositorService.getInstance().disconnect((EObject)conn);
    }
}

