/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.compose;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Observable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementReference;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.kernel.extension.IElementCompositor;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.service.IElementCompositorService;
import org.fortiss.tooling.kernel.service.IPersistencyService;

public abstract class ModelElementCompositorBase<C extends EObject>
extends Observable
implements IElementCompositor<C> {
    public boolean compose(C container, EObject contained, IElementCompositionContext context) {
        if (contained instanceof IModelElement) {
            IAnnotationValueService.getInstance().instantiateAnnotations((IModelElement)contained);
            ITopLevelElement topLevelElement = IPersistencyService.getInstance().getTopLevelElementFor(container);
            for (IModelElementSpecification specification : ((IModelElement)contained).getSpecifications()) {
                topLevelElement.prepareIDs((EObject)specification);
            }
        }
        this.makeNameDistinct((EObject)container, contained);
        return true;
    }

    public boolean decompose(EObject contained) {
        return this.iterateDecompose(contained) && this.decomposeSpecific(contained);
    }

    protected boolean decomposeSpecific(EObject contained) {
        EcoreUtil.delete((EObject)contained, (boolean)true);
        return true;
    }

    protected boolean iterateDecompose(EObject contained) {
        if (contained instanceof IModelElement) {
            if (!this.iterateDecomposeSpecifications((IModelElement)contained)) {
                return false;
            }
            if (!this.iterateDecomposeReference((IModelElement)contained)) {
                return false;
            }
        }
        return true;
    }

    private boolean iterateDecomposeReference(IModelElement me) {
        ArrayList<IModelElementReference> list = new ArrayList<IModelElementReference>((Collection<IModelElementReference>)me.getReferencedBy());
        for (IModelElementReference ref : list) {
            if (this.decomposeReference(ref)) continue;
            return false;
        }
        return true;
    }

    private boolean iterateDecomposeSpecifications(IModelElement me) {
        ArrayList<IModelElementSpecification> list = new ArrayList<IModelElementSpecification>((Collection<IModelElementSpecification>)me.getSpecifications());
        for (IModelElementSpecification spec : list) {
            if (this.decomposeSpecification(spec)) continue;
            return false;
        }
        return true;
    }

    protected boolean decomposeSpecification(IModelElementSpecification element) {
        if (IElementCompositorService.getInstance().canDecompose((EObject)element)) {
            return IElementCompositorService.getInstance().decompose((EObject)element);
        }
        return true;
    }

    protected boolean decomposeReference(IModelElementReference element) {
        element.setReference(null);
        EcoreUtil.delete((EObject)element, (boolean)true);
        return true;
    }

    public void makeNameDistinct(EObject container, EObject contained) {
        if (!(contained instanceof INamedElement) || ((INamedElement)contained).getName() == null) {
            return;
        }
        INamedElement neNew = (INamedElement)contained;
        String newName = ((INamedElement)contained).getName();
        ArrayList<String> listNames = new ArrayList<String>();
        for (EObject o : container.eContents()) {
            if (!o.getClass().isInstance(contained) || !(o instanceof INamedElement) || o == contained) continue;
            listNames.add(((INamedElement)o).getName());
        }
        if (!listNames.contains(newName)) {
            return;
        }
        int index = 1;
        while (listNames.contains(newName + index)) {
            ++index;
        }
        neNew.setName(neNew.getName() + index);
    }
}

