/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.dnd;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.ZoomUtils;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;

public class ElementDropContext
implements IElementCompositionContext {
    private EObject dropTarget;
    private Point position;
    private Point viewLocation;
    private boolean isRoot;
    private boolean isRootFigureCanvas;
    private double zoom;

    public ElementDropContext(EObject dropTarget, Point position, boolean isRoot, double zoom) {
        this.dropTarget = dropTarget;
        this.position = position;
        this.viewLocation = null;
        this.isRoot = isRoot;
        this.isRootFigureCanvas = false;
        this.zoom = zoom;
    }

    public ElementDropContext(EObject dropTarget, Point position, Point viewLocation, boolean isRoot, boolean isFigureCanvas, double zoom) {
        this(dropTarget, position, isRoot, zoom);
        this.viewLocation = viewLocation;
        this.isRootFigureCanvas = isFigureCanvas;
    }

    public Point getPosition() {
        return this.position;
    }

    public Point getViewLocationZoomed() {
        return ZoomUtils.screenToInternalPoint(this.viewLocation, this.zoom);
    }

    public EObject getDropTarget() {
        return this.dropTarget;
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean isRootFigureCanvas() {
        return this.isRootFigureCanvas;
    }
}

