/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.layout;

import javafx.geometry.Bounds;
import javafx.scene.text.Text;
import org.fortiss.tooling.base.layout.IAutoLayouterTapeMeasure;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public abstract class DiagramTapeMeasure
implements IAutoLayouterTapeMeasure {
    protected Bounds getTextExtent(IModelElement element) {
        if (!(element instanceof INamedElement)) {
            return null;
        }
        String name = ((INamedElement)element).getName();
        Text text = new Text(name);
        return text.getBoundsInLocal();
    }

    protected int getElementLength(int length, IHierarchicElement element) {
        int numElemConnectors = element.getConnectors().size();
        int numElemInputConnectors = EcoreUtils.pickInstanceOf(EntryConnectorBase.class, element.getConnectors()).size();
        int numConnectors = Math.max(numElemInputConnectors, numElemConnectors - numElemInputConnectors);
        return Math.max((1 + 2 * numConnectors) * 24, length);
    }

    @Override
    public int getElementWidth(IHierarchicElement element) {
        Dimension dimension = LayoutDataUtils.getNodeSize((ILayoutedModelElement)((Object)element));
        int width = Math.max(108, dimension.getWidth());
        Bounds textExtent = this.getTextExtent(element);
        if (textExtent != null) {
            width = Math.max(width, (int)textExtent.getWidth() + 72);
        }
        return width;
    }

    @Override
    public int getElementHeight(IHierarchicElement element) {
        Dimension dimension = LayoutDataUtils.getNodeSize((ILayoutedModelElement)((Object)element));
        return dimension.getHeight();
    }

    @Override
    public int getConnectorWidth(IConnector connector) {
        return 24;
    }

    @Override
    public int getConnectorHeight(IConnector connector) {
        return 24;
    }

    @Override
    public int getConnectionWidth(IConnection connection) {
        Bounds textExtend = this.getTextExtent(connection);
        return textExtend != null ? (int)textExtend.getWidth() : 0;
    }

    @Override
    public int getConnectorLabelWidth(IConnector connector) {
        Bounds textExtend = this.getTextExtent(connector);
        return textExtend != null ? (int)textExtend.getWidth() : 0;
    }
}

