/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.layout;

import java.util.Map;
import org.eclipse.elk.alg.layered.LayeredLayoutProvider;
import org.eclipse.elk.alg.layered.options.InteractiveReferencePoint;
import org.eclipse.elk.alg.layered.options.LayeredMetaDataProvider;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.PortLabelPlacement;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.BasicProgressMonitor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkBendPoint;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EMap;
import org.fortiss.tooling.base.layout.DiagramTapeMeasure;
import org.fortiss.tooling.base.layout.HorizontalDiagramTapeMeasure;
import org.fortiss.tooling.base.layout.IAutoLayouter;
import org.fortiss.tooling.base.layout.IAutoLayouterTapeMeasure;
import org.fortiss.tooling.base.layout.VerticalDiagramTapeMeasure;
import org.fortiss.tooling.base.model.base.EntryConnectorBase;
import org.fortiss.tooling.base.model.base.ExitConnectorBase;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutData;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Points;
import org.fortiss.tooling.base.model.layout.impl.PointsImpl;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.OffsetOrientationUtils;
import org.fortiss.tooling.kernel.model.INamedElement;

public class KielerAutoLayouter
implements IAutoLayouter {
    private EMap<IHierarchicElement, ElkNode> modelElementsToElkNodes;
    private EMap<IConnector, ElkPort> outboundConnectorsToElkPorts;
    private EMap<IConnector, ElkPort> inboundConnectorsToElkPorts;
    private EMap<IConnector, ElkPort> undirectedConnectorsToElkPorts;
    private EMap<IConnection, ElkEdge> connectionsToElkEdges;
    private EMap<IConnector, ElkPort> globalInboundConnectorsToElkPorts;
    private EMap<IConnector, ElkPort> globalOutboundConnectorsToElkPorts;

    @Override
    public void performAutoLayout(IHierarchicElement element) {
        LayoutMetaDataService.getInstance().registerLayoutMetaDataProviders(new ILayoutMetaDataProvider[]{new LayeredMetaDataProvider()});
        Direction direction = KielerAutoLayouter.getDiagramDirection(element);
        int offset = KielerAutoLayouter.getDiagramOffset(element);
        DiagramTapeMeasure tapeMeasure = direction.isHorizontal() ? new HorizontalDiagramTapeMeasure() : new VerticalDiagramTapeMeasure();
        ElkNode rootNode = this.createELKGraph(element, tapeMeasure);
        rootNode.setProperty(LayeredOptions.DIRECTION, (Object)direction);
        rootNode.setProperty(LayeredOptions.PADDING, (Object)new ElkPadding((double)offset));
        rootNode.setProperty(LayeredOptions.INTERACTIVE_LAYOUT, (Object)true);
        rootNode.setProperty(LayeredOptions.FEEDBACK_EDGES, (Object)true);
        rootNode.setProperty(LayeredOptions.EDGE_ROUTING, (Object)EdgeRouting.ORTHOGONAL);
        rootNode.setProperty(LayeredOptions.SPACING_NODE_NODE_BETWEEN_LAYERS, (Object)60.0);
        rootNode.setProperty(LayeredOptions.SPACING_EDGE_NODE_BETWEEN_LAYERS, (Object)24.0);
        rootNode.setProperty(LayeredOptions.INTERACTIVE_REFERENCE_POINT, (Object)InteractiveReferencePoint.TOP_LEFT);
        rootNode.setProperty(LayeredOptions.PORT_LABELS_PLACEMENT, (Object)PortLabelPlacement.outside());
        LayeredLayoutProvider layoutProvider = new LayeredLayoutProvider();
        BasicProgressMonitor progressMonitor = new BasicProgressMonitor();
        layoutProvider.layout(rootNode, (IElkProgressMonitor)progressMonitor);
        this.applyLayout(rootNode, element);
    }

    private static Direction getDiagramDirection(IHierarchicElement diagram) {
        OffsetOrientation offsetOrientation;
        if (diagram instanceof ILayoutedModelElement && (offsetOrientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)((Object)diagram), "diagorient")) != null) {
            switch (offsetOrientation.getOrientation()) {
                case NORTH: {
                    return Direction.UP;
                }
                case EAST: {
                    return Direction.RIGHT;
                }
                case SOUTH: {
                    return Direction.DOWN;
                }
                case WEST: {
                    return Direction.LEFT;
                }
            }
        }
        return Direction.RIGHT;
    }

    private static int getDiagramOffset(IHierarchicElement diagram) {
        OffsetOrientation offsetOrientation;
        if (diagram instanceof ILayoutedModelElement && (offsetOrientation = OffsetOrientationUtils.getOffsetOrientation((ILayoutedModelElement)((Object)diagram), "diagorient")) != null) {
            return offsetOrientation.getOffset();
        }
        return 0;
    }

    private int truncateSnap2Grid(double f) {
        return this.truncateSnap2Grid(f, false);
    }

    private int truncateSnap2Grid(double f, boolean enlarge) {
        int rval = (int)f;
        int deviationFromGrid = rval % 12;
        if (deviationFromGrid > 0 && enlarge) {
            rval += 12;
        }
        return rval -= deviationFromGrid;
    }

    private void applyLayout(ElkNode template, IHierarchicElement element) {
        this.filterBendPoints(element);
        for (IHierarchicElement child : element.getContainedElements()) {
            ElkNode elkNode = (ElkNode)this.modelElementsToElkNodes.get((Object)child);
            LayoutDataUtils.setNodeLayoutData((ILayoutedModelElement)((Object)child), this.truncateSnap2Grid(elkNode.getX()), this.truncateSnap2Grid(elkNode.getY()), this.truncateSnap2Grid(elkNode.getWidth(), true), this.truncateSnap2Grid(elkNode.getHeight(), true));
        }
        for (Map.Entry entry : this.connectionsToElkEdges) {
            ElkEdge elkEdge = (ElkEdge)entry.getValue();
            IConnection connection = (IConnection)entry.getKey();
            for (ElkEdgeSection section : elkEdge.getSections()) {
                for (ElkBendPoint bendPoint : section.getBendPoints()) {
                    LayoutDataUtils.addBendPointToConnection((ILayoutedModelElement)((Object)connection), this.truncateSnap2Grid(bendPoint.getX()), this.truncateSnap2Grid(bendPoint.getY()));
                }
            }
        }
        this.setPositionsForConnectors(this.outboundConnectorsToElkPorts);
        this.setPositionsForConnectors(this.inboundConnectorsToElkPorts);
        this.setPositionsForGlobalConnectors(this.globalInboundConnectorsToElkPorts);
        this.setPositionsForGlobalConnectors(this.globalOutboundConnectorsToElkPorts);
    }

    private void setPositionsForGlobalConnectors(EMap<IConnector, ElkPort> globalConnectors) {
        for (Map.Entry entry : globalConnectors) {
            IConnector connector = (IConnector)entry.getKey();
            ElkPort elkPort = (ElkPort)entry.getValue();
            ElkNode tempNode = elkPort.getParent();
            LayoutDataUtils.setNodePosition((ILayoutedModelElement)((Object)connector), this.truncateSnap2Grid(tempNode.getX()), this.truncateSnap2Grid(tempNode.getY()));
        }
    }

    private void setPositionsForConnectors(EMap<IConnector, ElkPort> connectors) {
        for (Map.Entry entry : connectors) {
            double parentGridOffset;
            ElkPort elkPort = (ElkPort)entry.getValue();
            IConnector connector = (IConnector)entry.getKey();
            PortSide side = (PortSide)elkPort.getProperty(LayeredOptions.PORT_SIDE);
            EOrientation orientation = null;
            switch (side) {
                case NORTH: {
                    orientation = EOrientation.NORTH;
                    break;
                }
                case WEST: {
                    orientation = EOrientation.WEST;
                    break;
                }
                case EAST: {
                    orientation = EOrientation.EAST;
                    break;
                }
                case SOUTH: {
                    orientation = EOrientation.SOUTH;
                }
            }
            if (side == PortSide.WEST || side == PortSide.EAST) {
                parentGridOffset = elkPort.getParent().getY() % 12.0;
                LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)((Object)connector), orientation, this.truncateSnap2Grid(elkPort.getY() + parentGridOffset));
                continue;
            }
            parentGridOffset = elkPort.getParent().getX() % 12.0;
            LayoutDataUtils.setStickyConnectorLayoutData((ILayoutedModelElement)((Object)connector), orientation, this.truncateSnap2Grid(elkPort.getX() + parentGridOffset));
        }
    }

    private void filterBendPoints(IHierarchicElement element) {
        for (IConnection connection : element.getConnections()) {
            for (ILayoutData layoutData : ((ILayoutedModelElement)((Object)connection)).getLayoutData()) {
                if (!(layoutData instanceof Points) && !(layoutData instanceof PointsImpl)) continue;
                ((Points)layoutData).getPoints().clear();
            }
        }
    }

    private ElkNode createELKGraph(IHierarchicElement element, IAutoLayouterTapeMeasure tapeMeasure) {
        ElkNode rootNode = ElkGraphUtil.createGraph();
        this.modelElementsToElkNodes = new BasicEMap();
        this.outboundConnectorsToElkPorts = new BasicEMap();
        this.inboundConnectorsToElkPorts = new BasicEMap();
        this.connectionsToElkEdges = new BasicEMap();
        this.undirectedConnectorsToElkPorts = new BasicEMap();
        for (IHierarchicElement child : element.getContainedElements()) {
            if (!(child instanceof ILayoutedModelElement)) continue;
            ElkNode elkNode = ElkGraphUtil.createNode((ElkNode)rootNode);
            int width = tapeMeasure.getElementWidth(child);
            elkNode.setWidth((double)this.truncateSnap2Grid(width, true));
            int height = tapeMeasure.getElementHeight(child);
            elkNode.setHeight((double)this.truncateSnap2Grid(height, true));
            this.modelElementsToElkNodes.put((Object)child, (Object)elkNode);
            BasicEList inputConnectors = new BasicEList();
            BasicEList outputConnectors = new BasicEList();
            BasicEList undirectedConnectors = new BasicEList();
            for (IConnector connector : child.getConnectors()) {
                if (connector instanceof EntryConnectorBase) {
                    inputConnectors.add((Object)connector);
                    continue;
                }
                if (connector instanceof ExitConnectorBase) {
                    outputConnectors.add((Object)connector);
                    continue;
                }
                outputConnectors.add((Object)connector);
                undirectedConnectors.add((Object)connector);
            }
            for (IConnector connector : outputConnectors) {
                ElkPort k = this.createKPortFromIConnector(tapeMeasure, connector, elkNode, this.outboundConnectorsToElkPorts);
                if (!undirectedConnectors.contains((Object)connector)) continue;
                this.undirectedConnectorsToElkPorts.put((Object)connector, (Object)k);
            }
            for (IConnector connector : inputConnectors) {
                this.createKPortFromIConnector(tapeMeasure, connector, elkNode, this.inboundConnectorsToElkPorts);
            }
        }
        this.globalInboundConnectorsToElkPorts = new BasicEMap();
        this.globalOutboundConnectorsToElkPorts = new BasicEMap();
        for (IConnector connector : element.getConnectors()) {
            ElkNode elkNodeVirtual = ElkGraphUtil.createNode((ElkNode)rootNode);
            elkNodeVirtual.setWidth((double)tapeMeasure.getConnectorWidth(connector));
            elkNodeVirtual.setHeight((double)tapeMeasure.getConnectorHeight(connector));
            ElkPort elkPort = ElkGraphUtil.createPort((ElkNode)elkNodeVirtual);
            if (connector instanceof ExitConnectorBase) {
                this.globalOutboundConnectorsToElkPorts.put((Object)connector, (Object)elkPort);
                continue;
            }
            this.globalInboundConnectorsToElkPorts.put((Object)connector, (Object)elkPort);
        }
        BasicEMap sourceConnectors = new BasicEMap();
        sourceConnectors.putAll(this.outboundConnectorsToElkPorts);
        sourceConnectors.putAll(this.globalInboundConnectorsToElkPorts);
        for (Map.Entry entry : sourceConnectors) {
            for (IConnection connection : ((IConnector)entry.getKey()).getOutgoing()) {
                ElkPort kSourcePort = (ElkPort)entry.getValue();
                ElkPort kTargetPort = (ElkPort)this.inboundConnectorsToElkPorts.get((Object)connection.getTarget());
                if (kTargetPort == null) {
                    kTargetPort = (ElkPort)this.globalOutboundConnectorsToElkPorts.get((Object)connection.getTarget());
                }
                if (kTargetPort == null) {
                    kTargetPort = (ElkPort)this.undirectedConnectorsToElkPorts.get((Object)connection.getTarget());
                }
                ElkEdge elkEdge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)kSourcePort, (ElkConnectableShape)kTargetPort);
                ElkLabel elkLabel = ElkGraphUtil.createLabel((ElkGraphElement)elkEdge);
                int width = tapeMeasure.getConnectionWidth(connection);
                elkLabel.setWidth((double)this.truncateSnap2Grid(width, true));
                this.connectionsToElkEdges.put((Object)connection, (Object)elkEdge);
            }
        }
        return rootNode;
    }

    private ElkPort createKPortFromIConnector(IAutoLayouterTapeMeasure tapeMeasure, IConnector connector, ElkNode elkNode, EMap<IConnector, ElkPort> connectorsToelkPorts) {
        ElkPort elkPort = ElkGraphUtil.createPort((ElkNode)elkNode);
        elkPort.setParent(elkNode);
        elkPort.setWidth(24.0);
        elkPort.setHeight(24.0);
        if (connector instanceof INamedElement) {
            ElkLabel elkPortLabel = ElkGraphUtil.createLabel((ElkGraphElement)elkPort);
            String name = ((INamedElement)connector).getName();
            elkPortLabel.setWidth((double)tapeMeasure.getConnectorLabelWidth(connector));
            elkPortLabel.setText(name);
        }
        connectorsToelkPorts.put((Object)connector, (Object)elkPort);
        return elkPort;
    }
}

