/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.migration;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.fortiss.tooling.base.ToolingBaseActivator;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.kernel.extension.IMigrationProvider;
import org.fortiss.tooling.kernel.extension.data.ITopLevelElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class RemoveDuplicatedAnnotationsMigrationProvider
implements IMigrationProvider {
    public boolean needMigration(ITopLevelElement topLevelElement, Map<EObject, AnyType> unknownFeatures) {
        return this.doInternal(topLevelElement, false);
    }

    private boolean doInternal(ITopLevelElement topLevelElement, boolean migrate) {
        HashSet observedAnnotationClasses = new HashSet();
        for (IModelElement modelElement : EcoreUtils.getChildrenWithType((EObject)topLevelElement.getRootModelElement(), IModelElement.class)) {
            observedAnnotationClasses.clear();
            for (IAnnotatedSpecification annotation : EcoreUtils.pickInstanceOf(IAnnotatedSpecification.class, modelElement.getSpecifications())) {
                Class<?> annotationClass = annotation.getClass();
                if (observedAnnotationClasses.contains(annotationClass)) {
                    if (migrate) {
                        modelElement.getSpecifications().remove((Object)annotation);
                    } else {
                        return true;
                    }
                }
                observedAnnotationClasses.add(annotation.getClass());
            }
        }
        return false;
    }

    public Map<EObject, AnyType> migrate(ITopLevelElement topLevelElement, Map<EObject, AnyType> unknownFeatures) {
        this.doInternal(topLevelElement, true);
        URI uri = topLevelElement.getRootModelElement().eResource().getURI();
        LoggingUtils.error((Plugin)ToolingBaseActivator.getDefault(), (String)("Duplicate annotations have been removed from \"" + uri.lastSegment() + "\". Please report this incident since it indicates an internal problem."));
        return Collections.emptyMap();
    }
}

