/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.model.layout;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EOrientation implements Enumerator
{
    NORTH(0, "NORTH", "NORTH"),
    EAST(1, "EAST", "EAST"),
    SOUTH(2, "SOUTH", "SOUTH"),
    WEST(3, "WEST", "WEST");

    public static final int NORTH_VALUE = 0;
    public static final int EAST_VALUE = 1;
    public static final int SOUTH_VALUE = 2;
    public static final int WEST_VALUE = 3;
    private static final EOrientation[] VALUES_ARRAY;
    public static final List<EOrientation> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EOrientation[]{NORTH, EAST, SOUTH, WEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EOrientation get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EOrientation result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EOrientation getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EOrientation result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EOrientation get(int value) {
        switch (value) {
            case 0: {
                return NORTH;
            }
            case 1: {
                return EAST;
            }
            case 2: {
                return SOUTH;
            }
            case 3: {
                return WEST;
            }
        }
        return null;
    }

    private EOrientation(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

