/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.model.layout.impl;

import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;

public class PointStaticImpl {
    public static Dimension getDifference(Point selfPoint, Point compPoint) {
        return LayoutModelElementFactory.createDimension(selfPoint.getX() - compPoint.getX(), selfPoint.getY() - compPoint.getY(), "Dim_" + selfPoint.toString() + "<->" + compPoint.toString());
    }

    public static Point getTranslated(Point point, int offsetX, int offsetY) {
        Point retPoint = LayoutModelElementFactory.createPoint(point.getX(), point.getY(), point.toString() + "_translated");
        return PointStaticImpl.translate(retPoint, offsetX, offsetY);
    }

    public static Point scale(Point point, double factor) {
        return PointStaticImpl.scale(point, factor, factor);
    }

    private static Point scale(Point point, double factorX, double factorY) {
        point.setX((int)Math.floor((double)point.getX() * factorX));
        point.setY((int)Math.floor((double)point.getY() * factorY));
        return point;
    }

    public static Point translate(Point point, int offsetX, int offsetY) {
        point.setX(point.getX() + offsetX);
        point.setY(point.getY() + offsetY);
        return point;
    }
}

