/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import java.util.stream.DoubleStream;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.ToolingBaseActivator;
import org.fortiss.tooling.base.annotation.AnnotationEntry;
import org.fortiss.tooling.base.annotation.AnnotationValueService;
import org.fortiss.tooling.base.annotation.IAnnotationValueService;
import org.fortiss.tooling.base.annotation.valueprovider.EStructuralFeatureDescriptor;
import org.fortiss.tooling.base.annotation.valueprovider.IAnnotationValueProvider;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.utils.BaseMathUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;
import org.fortiss.tooling.kernel.utils.LoggingUtils;

public class AnnotationUtils {
    public static <T extends IAnnotatedSpecification, U> U getAnnotationValue(IModelElement modelElement, Class<T> clazz, Class<U> valueType) {
        T annotation;
        IAnnotationValueProvider<T> annValProvider = AnnotationUtils.getAnnotationValueProvider(modelElement, clazz);
        Object value = annValProvider.getAnnotationValue(annotation = AnnotationUtils.getAnnotation(modelElement, clazz));
        if (value != null && !valueType.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("The value of the annotation " + clazz.getSimpleName() + " of the model element " + String.valueOf(modelElement) + " is not of the expected type " + valueType.getSimpleName());
        }
        return value;
    }

    public static <T extends IAnnotatedSpecification, U> void setAnnotationValue(IModelElement modelElement, Class<T> clazz, U value) throws Exception {
        IAnnotationValueProvider<T> annValProvider = AnnotationUtils.getAnnotationValueProvider(modelElement, clazz);
        T annotation = AnnotationUtils.getAnnotation(modelElement, clazz);
        annValProvider.setAnnotationValue(value, annotation);
    }

    public static boolean hasAnnotation(IModelElement modelElement, Class<? extends IAnnotatedSpecification> type) {
        IAnnotationValueService as = IAnnotationValueService.getInstance();
        return as.getAnnotationEntry(modelElement).getSpecification(type) != null;
    }

    public static <T extends IAnnotatedSpecification> T getAnnotation(IModelElement modelElement, Class<T> clazz) {
        return (T)((IAnnotatedSpecification)EcoreUtils.pickFirstInstanceOf(clazz, modelElement.getSpecifications()));
    }

    public static <T extends IAnnotatedSpecification> IAnnotationValueProvider<T> getAnnotationValueProvider(IModelElement element, Class<T> annotationType) {
        AnnotationEntry annEntry = AnnotationValueService.getInstance().getAnnotationEntry(element);
        return annEntry.getAnnotationValueProvider(annotationType);
    }

    public static List<IAnnotatedSpecification> getAnnotationsOf(IModelElement modelElement) {
        return EcoreUtils.pickInstanceOf(IAnnotatedSpecification.class, modelElement.getSpecifications());
    }

    public static <T extends IAnnotatedSpecification> EList<T> getParentAnnotationsWithType(IModelElement startElement, Class<T> clazz) {
        BasicEList parentAnnotationList = new BasicEList();
        EList parentsElements = EcoreUtils.getParentsWithType((EObject)startElement, IModelElement.class);
        for (IModelElement parentElement : parentsElements) {
            IAnnotatedSpecification annotation = (IAnnotatedSpecification)EcoreUtils.pickFirstInstanceOf(clazz, parentElement.getSpecifications());
            parentAnnotationList.add((Object)annotation);
        }
        return parentAnnotationList;
    }

    public static <T extends IAnnotatedSpecification> IAnnotationValueProvider.AnnotationAction<T> createRandValInputAction(IAnnotationValueProvider<T> provider, EStructuralFeatureDescriptor valType) {
        BiConsumer randomValuePropagation = (spec, parameters) -> {
            Object annotation = parameters.getAnnotation();
            EStructuralFeatureDescriptor featureDescriptor = provider.getEStructuralFeatureDescriptor();
            EClassifier featureType = featureDescriptor.getEType((IAnnotatedSpecification)annotation);
            IAnnotationValueProvider.AnnotationActionInputParameters params = parameters.getInputParameters();
            Object value = params.get("Average Value:", featureType.getInstanceClass());
            Object bound = params.get("Bound:        ", featureType.getInstanceClass());
            Double dValue = null;
            Double dBound = null;
            if (value instanceof Number && bound instanceof Number) {
                dValue = ((Number)value).doubleValue();
                dBound = ((Number)bound).doubleValue();
            }
            if (dValue == null || dBound == null) {
                LoggingUtils.error((Plugin)ToolingBaseActivator.getDefault(), (String)("Generation of random values for " + annotation.getName() + ": The average value or bound type is not number."));
                return;
            }
            Random rand = new Random();
            DoubleStream doubleStream = rand.doubles(dValue - dBound, dValue + dBound);
            Double randVal = doubleStream.findAny().getAsDouble();
            Class targetNumberType = featureType.getInstanceClass();
            randVal = BaseMathUtils.convertNumber(randVal, targetNumberType);
            try {
                provider.setAnnotationValue(randVal, annotation);
            }
            catch (Exception e) {
                LoggingUtils.error((Plugin)ToolingBaseActivator.getDefault(), (String)("Could not set the value of the annotation " + annotation.getName() + " when trying to propagate the value form the selected annotation."), (Throwable)e);
            }
        };
        IAnnotationValueProvider.AnnotationActionReqInputParameters randInputParameters = new IAnnotationValueProvider.AnnotationActionReqInputParameters();
        randInputParameters.add(new IAnnotationValueProvider.AnnotationActionReqInputParameter("Average Value:", valType));
        randInputParameters.add(new IAnnotationValueProvider.AnnotationActionReqInputParameter("Bound:        ", valType));
        IAnnotationValueProvider.AnnotationActionEntry randValuePropDescriptor = new IAnnotationValueProvider.AnnotationActionEntry("Create random values", IAnnotationValueProvider.AnnotationActionEntry.ActionScope.ALL_VISIBLE_ITEMS, true, randInputParameters);
        return new IAnnotationValueProvider.AnnotationAction(randValuePropDescriptor, randomValuePropagation);
    }

    public static void instantiateAnnotationsRecursive(EObject element) {
        IAnnotationValueService as = IAnnotationValueService.getInstance();
        if (element instanceof IModelElement) {
            as.instantiateAnnotations((IModelElement)element);
        }
        for (IModelElement child : EcoreUtils.getChildrenWithType((EObject)element, IModelElement.class)) {
            as.instantiateAnnotations(child);
        }
    }

    public static boolean requiresAnnotationInstantiation(IModelElement element) {
        return IAnnotationValueService.getInstance().requiresAnnotationInstantiation(element);
    }
}

