/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.lang.math.NumberUtils;

public class BaseMathUtils {
    public static <T extends Number> T convertNumber(Number number, Class<T> targetType) {
        if (targetType.isInstance(number)) {
            return (T)number;
        }
        if (targetType.equals(Byte.class) || targetType.equals(Byte.TYPE)) {
            long value = Long.MIN_VALUE;
            value = number instanceof Float || number instanceof Double ? Math.round(number.doubleValue()) : number.longValue();
            if (value < -128L || value > 127L) {
                throw BaseMathUtils.createOverUnderFlowException(number, targetType);
            }
            return (T)Byte.valueOf(number.byteValue());
        }
        if (targetType.equals(Short.class) || targetType.equals(Short.TYPE)) {
            long value = Long.MIN_VALUE;
            value = number instanceof Float || number instanceof Double ? Math.round(number.doubleValue()) : number.longValue();
            if (value < -32768L || value > 32767L) {
                throw BaseMathUtils.createOverUnderFlowException(number, targetType);
            }
            return (T)Short.valueOf(number.shortValue());
        }
        if (targetType.equals(Integer.class) || targetType.equals(Integer.TYPE)) {
            long value = Long.MIN_VALUE;
            value = number instanceof Float || number instanceof Double ? Math.round(number.doubleValue()) : number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                BaseMathUtils.createOverUnderFlowException(number, targetType);
            }
            return (T)Integer.valueOf(number.intValue());
        }
        if (targetType.equals(Long.class) || targetType.equals(Long.TYPE)) {
            long value = Long.MIN_VALUE;
            value = number instanceof Float || number instanceof Double ? Math.round(number.doubleValue()) : number.longValue();
            return (T)Long.valueOf(value);
        }
        if (targetType.equals(BigInteger.class)) {
            return (T)BigInteger.valueOf(number.longValue());
        }
        if (targetType.equals(Float.class) || targetType.equals(Float.TYPE)) {
            double value = number.doubleValue();
            if (value < (double)1.4E-45f || value > 3.4028234663852886E38) {
                throw BaseMathUtils.createOverUnderFlowException(number, targetType);
            }
            return (T)Float.valueOf(number.floatValue());
        }
        if (targetType.equals(Double.class) || targetType.equals(Double.TYPE)) {
            return (T)Double.valueOf(number.doubleValue());
        }
        if (targetType.equals(BigDecimal.class)) {
            return (T)new BigDecimal(number.doubleValue());
        }
        throw new ArithmeticException("Unable to convert the number " + String.valueOf(number) + " to the type " + targetType.getSimpleName() + ".");
    }

    public static <T extends Number> T getNumberFromString(String numString, Class<T> expectedType) {
        Number value = null;
        if (NumberUtils.isNumber((String)numString)) {
            if (expectedType.isAssignableFrom(Byte.class) || expectedType.equals(Byte.TYPE)) {
                value = Byte.valueOf(numString);
            } else if (expectedType.isAssignableFrom(Double.class) || expectedType.equals(Double.TYPE)) {
                value = Double.valueOf(numString);
            } else if (expectedType.isAssignableFrom(Float.class) || expectedType.equals(Float.TYPE)) {
                value = Float.valueOf(numString);
            } else if (expectedType.isAssignableFrom(Integer.class) || expectedType.equals(Integer.TYPE)) {
                value = Integer.valueOf(numString);
            } else if (expectedType.isAssignableFrom(Long.class) || expectedType.equals(Long.TYPE)) {
                value = Long.valueOf(numString);
            } else if (expectedType.isAssignableFrom(Short.class) || expectedType.equals(Short.TYPE)) {
                value = Short.valueOf(numString);
            } else if (expectedType.isAssignableFrom(BigDecimal.class)) {
                DecimalFormat df = (DecimalFormat)NumberFormat.getInstance(new Locale("en", "US"));
                df.setParseBigDecimal(true);
                value = df.parse(numString, new ParsePosition(0));
            } else if (expectedType.isAssignableFrom(BigInteger.class)) {
                value = new BigInteger(numString);
            }
        }
        return (T)value;
    }

    public static boolean isExpectedType(Number value, Class<? extends Number> expectedType) {
        if (expectedType.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (value instanceof Byte && expectedType.equals(Byte.TYPE)) {
            return true;
        }
        if (value instanceof Double && expectedType.equals(Double.TYPE)) {
            return true;
        }
        if (value instanceof Float && expectedType.equals(Float.TYPE)) {
            return true;
        }
        if (value instanceof Integer && expectedType.equals(Integer.TYPE)) {
            return true;
        }
        if (value instanceof Long && expectedType.equals(Long.TYPE)) {
            return true;
        }
        return value instanceof Short && expectedType.equals(Short.TYPE);
    }

    public static boolean isIntegerNumber(Number value) {
        return value != null && BaseMathUtils.isIntegerNumber(value.getClass());
    }

    public static boolean isIntegerNumber(Class<?> valueType) {
        return Byte.class.isAssignableFrom(valueType) || Short.class.isAssignableFrom(valueType) || Integer.class.isAssignableFrom(valueType) || Long.class.isAssignableFrom(valueType) || BigInteger.class.isAssignableFrom(valueType);
    }

    public static boolean isFloatNumber(Number value) {
        return value != null && BaseMathUtils.isFloatNumber(value.getClass());
    }

    public static boolean isFloatNumber(Class<?> valueType) {
        return Float.class.isAssignableFrom(valueType) || Double.class.isAssignableFrom(valueType) || BigDecimal.class.isAssignableFrom(valueType);
    }

    public static ArithmeticException createOverUnderFlowException(Number number, Class<?> targetType) {
        return new ArithmeticException("Number Over-/Underflow deetected: The number " + String.valueOf(number) + " is too large to be casted to the type " + targetType.getSimpleName() + ".");
    }
}

