/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.layout.Angle;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.AngleUtils;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public final class EllipseLayoutUtils {
    public static Polar calculateEllipseBorderPolar(double angle, Dimension ellipseSize, int inset) {
        double a = ellipseSize.getWidth() / 2 - inset;
        double b = ellipseSize.getHeight() / 2 - inset;
        double epsilon = Math.sqrt(a * a - b * b) / a;
        double r = b / Math.sqrt(1.0 - epsilon * epsilon * Math.cos(angle) * Math.cos(angle));
        return new Polar(angle, r);
    }

    public static Point calculateEllipseBorderPoint(double angle, Dimension ellipseSize, int inset) {
        Polar polar = EllipseLayoutUtils.calculateEllipseBorderPolar(angle, ellipseSize, inset);
        return polar.toCartesian().translate(ellipseSize.getScaled(0.5));
    }

    public static void layoutConnectorInEllipse(ILayoutedModelElement layouted, ILayoutedModelElement container, Point location) {
        Point position = (Point)EcoreUtils.copy((EObject)location);
        Point np = LayoutDataUtils.getNodePosition(container);
        position.translate(-np.getX(), -np.getY());
        Dimension nd = LayoutDataUtils.getNodeSize(container);
        Dimension d = LayoutModelElementFactory.createDimension(nd.getWidth(), nd.getHeight(), nd.toString() + "_Dimension");
        position.translate(d.getScaled(-0.5));
        EllipseLayoutUtils.setConnectorAngle(layouted, new Polar((Point)position).angle);
    }

    public static void setConnectorAngle(ILayoutedModelElement layouted, double angle) {
        AngleUtils.setAngle(layouted, "cangle", angle);
    }

    public static Angle getConnectorAngle(ILayoutedModelElement layouted) {
        Angle angle = AngleUtils.getAngle(layouted, "cangle");
        if (angle == null) {
            return LayoutModelElementFactory.createAngle(0.0, "cangle");
        }
        return angle;
    }

    public static class Polar {
        public double angle;
        public double distance;

        public Polar(double angle, double distance) {
            this.angle = angle;
            this.distance = distance;
        }

        public Polar(Point pos) {
            this.angle = Math.atan2(pos.getY(), pos.getX());
            this.distance = Math.sqrt(pos.getX() * pos.getX() + pos.getY() * pos.getY());
        }

        public Point toCartesian() {
            int x = (int)(this.distance * Math.cos(this.angle));
            int y = (int)(this.distance * Math.sin(this.angle));
            return LayoutModelElementFactory.createPoint(x, y, this.toString() + "_Polar");
        }
    }
}

