/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import java.util.ArrayList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.layout.Angle;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.LayoutFactory;
import org.fortiss.tooling.base.model.layout.Offset;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.model.layout.Points;
import org.fortiss.tooling.base.model.layout.Rectangle;
import org.fortiss.tooling.base.utils.AngleUtils;
import org.fortiss.tooling.base.utils.DimensionUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.base.utils.OffsetOrientationUtils;
import org.fortiss.tooling.base.utils.PointUtils;
import org.fortiss.tooling.base.utils.PointsUtils;
import org.fortiss.tooling.base.utils.RectangleLayoutUtils;
import org.fortiss.tooling.kernel.extension.data.IElementCompositionContext;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class LayoutDataUtils {
    public static void setNodeLayoutData(ILayoutedModelElement layouted, int xPos, int yPos, int width, int height) {
        Rectangle rect = LayoutModelElementFactory.createRectangle(xPos, yPos, width, height);
        LayoutDataUtils.setNodeBounds(layouted, rect);
    }

    public static void setNodeLayoutData(ILayoutedModelElement layouted, int xPos, int yPos) {
        LayoutDataUtils.setNodePosition(layouted, xPos, yPos);
    }

    public static void setStickyConnectorLayoutData(ILayoutedModelElement layouted, EOrientation orientation, int offset) {
        OffsetOrientationUtils.setOffsetOrientation(layouted, "coffsetorient", offset, orientation);
    }

    public static Rectangle getNodeBounds(ILayoutedModelElement layouted) {
        Point p = LayoutDataUtils.getNodePosition(layouted);
        Dimension d = LayoutDataUtils.getNodeSize(layouted);
        return LayoutModelElementFactory.createRectangle(p.getX(), p.getY(), d.getWidth(), d.getHeight());
    }

    public static void setNodeBounds(ILayoutedModelElement layouted, Rectangle bounds) {
        LayoutDataUtils.setNodePosition(layouted, bounds.getX(), bounds.getY());
        LayoutDataUtils.setNodeSize(layouted, bounds.getWidth(), bounds.getHeight());
    }

    public static Point getNodePosition(ILayoutedModelElement layouted) {
        return PointUtils.getPosition(layouted, "pos");
    }

    public static void setNodePosition(ILayoutedModelElement layouted, int x, int y) {
        PointUtils.setPoint(layouted, "pos", x, y);
    }

    public static Dimension getNodeSize(ILayoutedModelElement layouted) {
        Dimension size = DimensionUtils.getDimension(layouted, "dim");
        if (size == null) {
            Dimension result = LayoutModelElementFactory.createDimension(108, 72, "dim");
            return result;
        }
        return (Dimension)EcoreUtils.copy((EObject)size);
    }

    public static void setNodeSize(ILayoutedModelElement layouted, int w, int h) {
        DimensionUtils.setDimension(layouted, "dim", w, h);
    }

    public static void moveNode(ILayoutedModelElement layouted, int dx, int dy) {
        Point p = LayoutDataUtils.getNodePosition(layouted);
        LayoutDataUtils.setNodePosition(layouted, p.getX() + dx, p.getY() + dy);
    }

    public static void setConnectorOffsetOrientation(ILayoutedModelElement layouted, OffsetOrientation orientation) {
        OffsetOrientationUtils.setOffsetOrientation(layouted, "coffsetorient", orientation.getOffset(), orientation.getOrientation());
    }

    public static void layoutModelElement(EObject element, IElementCompositionContext context) {
        if (element instanceof ILayoutedModelElement) {
            ILayoutedModelElement layouted = (ILayoutedModelElement)element;
            if (context instanceof ElementDropContext) {
                RectangleLayoutUtils.layoutNodeInRoot(layouted, (ElementDropContext)context, 12, true);
            } else if (context == null) {
                LayoutDataUtils.moveNode(layouted, 5, 5);
            }
        }
    }

    public static void filterAllLayoutData(EObject obj) {
        if (obj instanceof ILayoutedModelElement) {
            ((ILayoutedModelElement)obj).getLayoutData().clear();
        }
        TreeIterator contents = obj.eAllContents();
        ArrayList<ILayoutedModelElement> toClears = new ArrayList<ILayoutedModelElement>();
        while (contents.hasNext()) {
            EObject elt = (EObject)contents.next();
            if (!(elt instanceof ILayoutedModelElement)) continue;
            toClears.add((ILayoutedModelElement)elt);
        }
        for (ILayoutedModelElement toClear : toClears) {
            toClear.getLayoutData().clear();
        }
    }

    public static void moveAndResizeNode(ILayoutedModelElement layouted, int dx, int dy, int dw, int dh, int minWidth, int minHeight) {
        Point pos = LayoutDataUtils.getNodePosition(layouted);
        int posX = pos.getX() + dx;
        int posY = pos.getY() + dy;
        Dimension dim = LayoutDataUtils.getNodeSize(layouted);
        int dimW = dim.getWidth() + dw;
        int dimH = dim.getHeight() + dh;
        if (dimW < minWidth) {
            if (dx > 0) {
                posX = posX - minWidth - dimW;
            }
            dimW = minWidth;
        }
        if (dimH < minHeight) {
            if (dy > 0) {
                posY = posY - minHeight - dimH;
            }
            dimH = minHeight;
        }
        LayoutDataUtils.setNodePosition(layouted, posX, posY);
        LayoutDataUtils.setNodeSize(layouted, dimW, dimH);
    }

    public static Point getConnectorPosition(ILayoutedModelElement layouted) {
        return PointUtils.getPosition(layouted, "cpos");
    }

    public static void setConnectorPosition(ILayoutedModelElement layouted, int x, int y) {
        PointUtils.setPoint(layouted, "cpos", x, y);
    }

    public static OffsetOrientation getConnectorOffsetOrientation(ILayoutedModelElement layouted) {
        OffsetOrientation oo = OffsetOrientationUtils.getOffsetOrientation(layouted, "coffsetorient");
        if (oo == null) {
            return LayoutModelElementFactory.createOffsetOrientation(0, EOrientation.NORTH, "coffsetorient");
        }
        return oo;
    }

    public static EOrientation getConnectorOrientation(ILayoutedModelElement layouted) {
        return OffsetOrientationUtils.getOffsetOrientation(layouted, "coffsetorient").getOrientation();
    }

    public static Offset getConnectorOffset(ILayoutedModelElement layouted) {
        OffsetOrientation offset = OffsetOrientationUtils.getOffsetOrientation(layouted, "coffset");
        if (offset == null) {
            return LayoutModelElementFactory.createOffsetOrientation(0, EOrientation.NORTH, "coffset");
        }
        return offset;
    }

    public static void setConnectorAngle(ILayoutedModelElement layouted, double angle) {
        AngleUtils.setAngle(layouted, "cangle", angle);
    }

    public static Angle getConnectorAngle(ILayoutedModelElement layouted) {
        Angle angle = AngleUtils.getAngle(layouted, "cangle");
        if (angle == null) {
            return LayoutModelElementFactory.createAngle(0.0, "cangle");
        }
        return angle;
    }

    public static double getConnectorAngleAsDouble(ILayoutedModelElement lobject) {
        return LayoutDataUtils.getConnectorAngle(lobject).getAngle();
    }

    public static Point getAbsolute(OffsetOrientation oo, Dimension parentSize, int parentInsets) {
        Point pos = LayoutModelElementFactory.createPoint(0, 0, null);
        int offsetValue = oo.getOffset();
        switch (oo.getOrientation()) {
            case NORTH: {
                pos.setX(offsetValue);
                pos.setY(0);
                break;
            }
            case WEST: {
                pos.setX(0);
                pos.setY(offsetValue);
                break;
            }
            case SOUTH: {
                pos.setX(offsetValue);
                pos.setY(parentSize.getHeight() - 2 * parentInsets);
                break;
            }
            case EAST: {
                pos.setX(parentSize.getWidth() - 2 * parentInsets);
                pos.setY(offsetValue);
            }
        }
        return pos;
    }

    public static Points getConnectionPoints(ILayoutedModelElement lobject) {
        return PointsUtils.getPoints(lobject, "points");
    }

    public static void addConnectionPoint(ILayoutedModelElement lobject, int index, int x, int y) {
        Points existingPoints = LayoutDataUtils.getConnectionPoints(lobject);
        Point newPoint = LayoutModelElementFactory.createPoint(x, y, null);
        existingPoints.getPoints().add(index, (Object)newPoint);
        PointsUtils.setPoints(lobject, "points", existingPoints);
    }

    public static void changeConnectionPoint(ILayoutedModelElement lobject, int index, int x, int y) {
        Points pts = LayoutDataUtils.getConnectionPoints(lobject);
        Point np = LayoutModelElementFactory.createPoint(x, y, null);
        pts.getPoints().set(index, (Object)np);
        PointsUtils.setPoints(lobject, "points", pts);
    }

    public static void changeAllConnectionPoints(ILayoutedModelElement lobject, int dx, int dy) {
        Points pts = LayoutDataUtils.getConnectionPoints(lobject);
        Points newPoints = LayoutModelElementFactory.createPoints(null);
        if (pts != null) {
            for (Point p : pts.getPoints()) {
                Point np = LayoutModelElementFactory.createPoint(p.getX() + dx, p.getY() + dy, null);
                newPoints.getPoints().add((Object)np);
            }
            PointsUtils.setPoints(lobject, "points", newPoints);
        }
    }

    public static void removeConnectionPoint(ILayoutedModelElement lobject, int index) {
        Points pts = LayoutDataUtils.getConnectionPoints(lobject);
        pts.getPoints().remove(index);
        PointsUtils.setPoints(lobject, "points", pts);
    }

    public static void addBendPointToConnection(ILayoutedModelElement conn, int bendPointX, int bendPointY) {
        Point bendPoint = LayoutFactory.eINSTANCE.createPoint();
        bendPoint.setX(bendPointX);
        bendPoint.setY(bendPointY);
        LayoutDataUtils.getConnectionPoints(conn).getPoints().add((Object)bendPoint);
    }
}

