/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import org.fortiss.tooling.base.model.layout.Angle;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.LayoutFactory;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.model.layout.Points;
import org.fortiss.tooling.base.model.layout.Rectangle;
import org.fortiss.tooling.base.utils.DimensionUtils;
import org.fortiss.tooling.base.utils.PointUtils;

public final class LayoutModelElementFactory {
    public static void createNodeElementLayout(ILayoutedModelElement layouted) {
        PointUtils.setPoint(layouted, "pos", 0, 0);
        DimensionUtils.setDimension(layouted, "dim", 108, 72);
    }

    public static void createConnectorLayout(ILayoutedModelElement layouted) {
        PointUtils.setPoint(layouted, "pos", 0, 0);
        DimensionUtils.setDimension(layouted, "dim", 108, 72);
        Point cpos = LayoutModelElementFactory.createPoint(0, 0, "cpos");
        Dimension cdim = LayoutModelElementFactory.createDimension(0, 0, "cdim");
        layouted.getLayoutData().add((Object)cpos);
        layouted.getLayoutData().add((Object)cdim);
    }

    public static void createConnectionLayout(ILayoutedModelElement layouted) {
        Points points = LayoutModelElementFactory.createPoints("points");
        layouted.getLayoutData().add((Object)points);
    }

    public static Angle createAngle(double angle, String key) {
        Angle a = LayoutFactory.eINSTANCE.createAngle();
        a.setAngle(angle);
        a.setKey(key);
        return a;
    }

    public static Dimension createDimension(int w, int h, String key) {
        Dimension d = LayoutFactory.eINSTANCE.createDimension();
        d.setWidth(w);
        d.setHeight(h);
        d.setKey(key);
        return d;
    }

    public static Points createPoints(String key) {
        Points pts = LayoutFactory.eINSTANCE.createPoints();
        pts.setKey(key);
        return pts;
    }

    public static Point createPoint(int x, int y, String key) {
        Point p = LayoutFactory.eINSTANCE.createPoint();
        p.setX(x);
        p.setY(y);
        p.setKey(key);
        return p;
    }

    public static OffsetOrientation createOffsetOrientation(int offset, EOrientation orientation, String key) {
        OffsetOrientation oo = LayoutFactory.eINSTANCE.createOffsetOrientation();
        oo.setOrientation(orientation);
        oo.setOffset(offset);
        oo.setKey(key);
        return oo;
    }

    public static Rectangle createRectangle(int x, int y, int width, int height) {
        Rectangle rectangle = LayoutFactory.eINSTANCE.createRectangle();
        rectangle.setLocation(x, y);
        rectangle.setSize(width, height);
        return rectangle;
    }
}

