/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.fortiss.tooling.base.model.base.ConnectorBase;
import org.fortiss.tooling.base.model.base.HierarchicElementBase;
import org.fortiss.tooling.base.model.element.IAnnotatedSpecification;
import org.fortiss.tooling.base.model.element.IConnection;
import org.fortiss.tooling.base.model.element.IConnector;
import org.fortiss.tooling.base.model.element.IHierarchicElement;
import org.fortiss.tooling.base.model.element.IModelElement;
import org.fortiss.tooling.base.model.element.IModelElementReference;
import org.fortiss.tooling.base.model.element.IModelElementSpecification;
import org.fortiss.tooling.base.model.layout.ILayoutData;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.kernel.model.INamedCommentedElement;
import org.fortiss.tooling.kernel.model.INamedElement;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class MigrationUtils {
    public static void migrateConnectorBase(ConnectorBase oldConnectorBase, ConnectorBase newConnectorBase) {
        MigrationUtils.migrateINamedCommentedElement(oldConnectorBase, newConnectorBase);
        MigrationUtils.migrateILayoutedModelElement(oldConnectorBase, newConnectorBase);
        MigrationUtils.migrateIModelElement(oldConnectorBase, newConnectorBase);
        MigrationUtils.migrateIConnector(oldConnectorBase, newConnectorBase);
        EcoreUtil.delete((EObject)oldConnectorBase);
    }

    public static void migrateConnectorBase(ConnectorBase oldConnectorBase, ConnectorBase newConnectorBase, IHierarchicElement newElement) {
        MigrationUtils.migrateINamedCommentedElement(oldConnectorBase, newConnectorBase);
        MigrationUtils.migrateILayoutedModelElement(oldConnectorBase, newConnectorBase);
        MigrationUtils.migrateIModelElement(oldConnectorBase, newConnectorBase);
        newElement.getConnectors().add((Object)newConnectorBase);
    }

    public static void migrateIConnector(IConnector oldIConnector, IConnector newIConnector) {
        BasicEList connections = new BasicEList(oldIConnector.getIncoming());
        for (IConnection connection : connections) {
            connection.setTarget(newIConnector);
        }
        connections = new BasicEList(oldIConnector.getOutgoing());
        for (IConnection connection : connections) {
            connection.setSource(newIConnector);
        }
        EList<IConnector> connectors = oldIConnector.getOwner().getConnectors();
        int i = connectors.indexOf((Object)oldIConnector);
        connectors.remove(i);
        connectors.add(i, (Object)newIConnector);
    }

    public static void migrateIModelElement(IModelElement oldIModelElement, IModelElement newIModelElement) {
        newIModelElement.getSpecifications().clear();
        for (IModelElementSpecification specification : oldIModelElement.getSpecifications()) {
            newIModelElement.getSpecifications().add((Object)((IModelElementSpecification)EcoreUtils.copy((EObject)specification)));
        }
        newIModelElement.getReferencedBy().clear();
        for (IModelElementReference reference : oldIModelElement.getReferencedBy()) {
            newIModelElement.getReferencedBy().add((Object)((IModelElementReference)EcoreUtils.copy((EObject)reference)));
        }
    }

    public static void migrateILayoutedModelElement(ILayoutedModelElement oldILayoutedModelElement, ILayoutedModelElement newILayoutedModelElement) {
        newILayoutedModelElement.getLayoutData().clear();
        for (ILayoutData layoutData : oldILayoutedModelElement.getLayoutData()) {
            newILayoutedModelElement.getLayoutData().add((Object)((ILayoutData)EcoreUtils.copy((EObject)layoutData)));
        }
    }

    public static void migrateINamedElement(INamedElement oldINamedElement, INamedElement newINamedElement) {
        newINamedElement.setName(oldINamedElement.getName());
        newINamedElement.setId(oldINamedElement.getId());
    }

    public static void migrateINamedCommentedElement(INamedCommentedElement oldINamedCommentedElement, INamedCommentedElement newINamedCommentedElement) {
        MigrationUtils.migrateINamedElement((INamedElement)oldINamedCommentedElement, (INamedElement)newINamedCommentedElement);
        newINamedCommentedElement.setComment(oldINamedCommentedElement.getComment());
    }

    public static void migrateHierarchicElementBase(HierarchicElementBase oldElement, HierarchicElementBase newElement) {
        MigrationUtils.migrateIModelElement(oldElement, newElement);
        MigrationUtils.migrateILayoutedModelElement(oldElement, newElement);
        MigrationUtils.migrateINamedCommentedElement(oldElement, newElement);
    }

    public static void migrateIAnnotatedSpecification(IAnnotatedSpecification oldIAnnotatedSpecification, IAnnotatedSpecification newIAnnotatedSpecification) {
        MigrationUtils.migrateINamedElement(oldIAnnotatedSpecification, newIAnnotatedSpecification);
        newIAnnotatedSpecification.setSpecificationOf(oldIAnnotatedSpecification.getSpecificationOf());
    }
}

