/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.model.layout.ILayoutData;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public final class PointUtils {
    public static Point getPosition(ILayoutedModelElement layouted, String key) {
        Point point = PointUtils.getPoint(layouted, key);
        if (point == null) {
            int index = 0;
            EObject container = layouted.eContainer();
            if (container != null) {
                index = 1 + container.eContents().indexOf((Object)layouted);
            }
            Point p = LayoutModelElementFactory.createPoint(index * 20, index * 20, key);
            return p;
        }
        return (Point)EcoreUtils.copy((EObject)point);
    }

    private static Point getPoint(ILayoutedModelElement layouted, String key) {
        for (ILayoutData ld : layouted.getLayoutData()) {
            if (!ld.getKey().equals(key) || !(ld instanceof Point)) continue;
            return (Point)ld;
        }
        return null;
    }

    public static void setPoint(ILayoutedModelElement layouted, String key, int x, int y) {
        Point old = PointUtils.getPoint(layouted, key);
        if (old != null) {
            old.setX(x);
            old.setY(y);
        } else {
            layouted.getLayoutData().add((Object)LayoutModelElementFactory.createPoint(x, y, key));
        }
    }
}

