/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import org.eclipse.emf.ecore.EObject;
import org.fortiss.tooling.base.dnd.ElementDropContext;
import org.fortiss.tooling.base.model.layout.Dimension;
import org.fortiss.tooling.base.model.layout.EOrientation;
import org.fortiss.tooling.base.model.layout.ILayoutedModelElement;
import org.fortiss.tooling.base.model.layout.OffsetOrientation;
import org.fortiss.tooling.base.model.layout.Point;
import org.fortiss.tooling.base.utils.LayoutDataUtils;
import org.fortiss.tooling.base.utils.LayoutModelElementFactory;
import org.fortiss.tooling.base.utils.SnapToGridUtils;
import org.fortiss.tooling.kernel.utils.EcoreUtils;

public class RectangleLayoutUtils {
    public static OffsetOrientation calculateRectangleBorderOrientation(Point source, Dimension rectangleSize, int inset) {
        int offset;
        EOrientation orientation;
        int distToNorth = source.getY();
        int distToSouth = rectangleSize.getHeight() - source.getY() - 2 * inset;
        int distToWest = source.getX();
        int distToEast = rectangleSize.getWidth() - source.getX() - 2 * inset;
        int minDist = Math.min(Math.min(Math.min(distToEast, distToNorth), distToWest), distToSouth);
        if (minDist == distToNorth) {
            orientation = EOrientation.NORTH;
            offset = source.getX();
        } else if (minDist == distToWest) {
            orientation = EOrientation.WEST;
            offset = source.getY();
        } else if (minDist == distToSouth) {
            orientation = EOrientation.SOUTH;
            offset = source.getX();
        } else {
            orientation = EOrientation.EAST;
            offset = source.getY();
        }
        return LayoutModelElementFactory.createOffsetOrientation(offset, orientation, null);
    }

    public static void layoutConnectorInRectangle(ILayoutedModelElement layouted, ILayoutedModelElement container, Point location) {
        Point position = (Point)EcoreUtils.copy((EObject)location);
        Point np = LayoutDataUtils.getNodePosition(container);
        position.translate(-np.getX() - 12, -np.getY() - 12);
        Dimension nd = LayoutDataUtils.getNodeSize(container);
        Dimension d = LayoutModelElementFactory.createDimension(nd.getWidth(), nd.getHeight(), layouted.toString() + "_Dimension");
        OffsetOrientation orient = RectangleLayoutUtils.calculateRectangleBorderOrientation(position, d, 12);
        orient.setOffset(SnapToGridUtils.snapToGrid(orient.getOffset()));
        LayoutDataUtils.setConnectorOffsetOrientation(layouted, orient);
    }

    public static void layoutNodeInRoot(ILayoutedModelElement layouted, ElementDropContext context, int positionOffset, boolean snapToGrid) {
        RectangleLayoutUtils.layoutNodeInRoot(layouted, context.getPosition(), positionOffset, snapToGrid);
    }

    public static void layoutNodeInRoot(ILayoutedModelElement layouted, Point location, int positionOffset, boolean snapToGrid) {
        Point position = (Point)EcoreUtils.copy((EObject)location);
        position.translate(-positionOffset, -positionOffset);
        if (snapToGrid) {
            SnapToGridUtils.snapToGrid(position);
        }
        LayoutDataUtils.setNodePosition(layouted, position.getX(), position.getY());
    }
}

