/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import java.io.File;
import java.util.UUID;

public class SystemUtils {
    private static Boolean isWindowsPlatform = null;
    private static Boolean isLinuxPlatform = null;
    private static Boolean isMacOSXPlatform = null;
    private static Boolean isVm64BitArch;
    private static Boolean isOs64BitArch;

    public static boolean isWindowsPlatform() {
        if (isWindowsPlatform != null) {
            return isWindowsPlatform;
        }
        String osName = System.getProperty("os.name");
        isWindowsPlatform = osName != null && osName.contains("Windows");
        return isWindowsPlatform;
    }

    public static boolean isLinuxPlatform() {
        if (isLinuxPlatform != null) {
            return isLinuxPlatform;
        }
        String osName = System.getProperty("os.name");
        isLinuxPlatform = osName != null && osName.contains("Linux");
        return isLinuxPlatform;
    }

    public static boolean isMacOSXPlatform() {
        if (isMacOSXPlatform != null) {
            return isMacOSXPlatform;
        }
        String osName = System.getProperty("os.name");
        isMacOSXPlatform = osName != null && osName.contains("Mac OS X");
        return isMacOSXPlatform;
    }

    public static boolean isVm64BitArch() {
        if (isVm64BitArch != null) {
            return isVm64BitArch;
        }
        String osArch = System.getProperty("os.arch");
        isVm64BitArch = osArch != null && osArch.contains("64");
        return isVm64BitArch;
    }

    public static boolean isOs64BitArch() {
        if (isOs64BitArch != null) {
            return isOs64BitArch;
        }
        String progFilesX86 = System.getenv("ProgramFiles(x86)");
        isOs64BitArch = SystemUtils.isWindowsPlatform() ? progFilesX86 != null : SystemUtils.isVm64BitArch();
        return isOs64BitArch;
    }

    public static String interpretProcessExitValues(int exitValue) {
        if (!SystemUtils.isWindowsPlatform()) {
            switch (exitValue) {
                case 126: {
                    return "Command not found";
                }
                case 139: {
                    return "Segmentation fault";
                }
            }
        }
        return "";
    }

    public static String getSystemTempDirPath() {
        return SystemUtils.getTempDirPath(false, null);
    }

    public static String getTempDirPath(boolean unique, String subdir) {
        Object tmpDir = System.getProperty("java.io.tmpdir");
        if (unique) {
            tmpDir = (String)tmpDir + File.separator + String.valueOf(UUID.randomUUID());
        }
        if (subdir != null) {
            tmpDir = (String)tmpDir + File.separator + subdir;
        }
        return tmpDir;
    }
}

