/*
 * Decompiled with CFR 0.152.
 */
package org.fortiss.tooling.base.utils;

import java.util.List;
import org.fortiss.tooling.base.model.visualization.Axis;
import org.fortiss.tooling.base.model.visualization.DataPoint;
import org.fortiss.tooling.base.model.visualization.DataSet;
import org.fortiss.tooling.base.model.visualization.DataSetCollection;
import org.fortiss.tooling.base.model.visualization.Dimension;
import org.fortiss.tooling.base.model.visualization.VisualizationFactory;

public class VisualizationModelElementFactory {
    public static <T> Dimension<T> createDimension(String name) {
        Dimension dimension = VisualizationFactory.eINSTANCE.createDimension();
        dimension.setName(name);
        return dimension;
    }

    public static <T> Axis<T> createAxis(String name) {
        Axis axis = VisualizationFactory.eINSTANCE.createAxis();
        axis.setName(name);
        return axis;
    }

    public static <T> DataPoint<T> createDataPoint(T start, T end, Axis<T> axis, Dimension<T> dim) {
        DataPoint<T> dataPoint = VisualizationFactory.eINSTANCE.createDataPoint();
        dataPoint.setStart(start);
        dataPoint.setEnd(end);
        dataPoint.setAxis(axis);
        dataPoint.setDimension(dim);
        return dataPoint;
    }

    public static DataSet createDataSet(List<DataPoint<?>> dataPoints, String name) {
        DataSet dataSet = VisualizationModelElementFactory.createDataSet(name);
        dataSet.getPoints().addAll(dataPoints);
        return dataSet;
    }

    public static DataSet createDataSet(String name) {
        DataSet dataSet = VisualizationFactory.eINSTANCE.createDataSet();
        dataSet.setName(name);
        return dataSet;
    }

    public static DataSetCollection createDataSetCollection(List<DataSet> dataSets, List<Axis<?>> axis, List<Dimension<?>> dims) {
        DataSetCollection dataSetCollection = VisualizationFactory.eINSTANCE.createDataSetCollection();
        dataSetCollection.getSets().addAll(dataSets);
        dataSetCollection.getAxes().addAll(axis);
        dataSetCollection.getDimensions().addAll(dims);
        return dataSetCollection;
    }

    public static DataSetCollection createDataSetCollection() {
        return VisualizationFactory.eINSTANCE.createDataSetCollection();
    }
}

